
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * Execute a set of defined actions or workflows for each element of a data array
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "inputCollection",
    "outputCollection",
    "iterationParam",
    "max",
    "actions",
    "workflowId",
    "usedForCompensation"
})
public class ForEachState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Workflow expression selecting an array element of the states data
     * 
     */
    @JsonProperty("inputCollection")
    @JsonPropertyDescription("Workflow expression selecting an array element of the states data")
    private java.lang.String inputCollection;
    /**
     * Workflow expression specifying an array element of the states data to add the results of each iteration
     * 
     */
    @JsonProperty("outputCollection")
    @JsonPropertyDescription("Workflow expression specifying an array element of the states data to add the results of each iteration")
    private java.lang.String outputCollection;
    /**
     * Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array
     * 
     */
    @JsonProperty("iterationParam")
    @JsonPropertyDescription("Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array")
    private java.lang.String iterationParam;
    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    @JsonPropertyDescription("Specifies how upper bound on how many iterations may run in parallel")
    @DecimalMin("0")
    private int max = 0;
    /**
     * Actions to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("Actions to be executed for each of the elements of inputCollection")
    @Valid
    private List<Action> actions = new ArrayList<Action>();
    /**
     * Unique Id of a workflow to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("workflowId")
    @JsonPropertyDescription("Unique Id of a workflow to be executed for each of the elements of inputCollection")
    private java.lang.String workflowId;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = -6827266823718323996L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ForEachState() {
    }

    /**
     * 
     * @param name
     * @param type
     */
    public ForEachState(java.lang.String name, DefaultState.Type type) {
        super(name, type);
    }

    /**
     * Workflow expression selecting an array element of the states data
     * 
     */
    @JsonProperty("inputCollection")
    public java.lang.String getInputCollection() {
        return inputCollection;
    }

    /**
     * Workflow expression selecting an array element of the states data
     * 
     */
    @JsonProperty("inputCollection")
    public void setInputCollection(java.lang.String inputCollection) {
        this.inputCollection = inputCollection;
    }

    public ForEachState withInputCollection(java.lang.String inputCollection) {
        this.inputCollection = inputCollection;
        return this;
    }

    /**
     * Workflow expression specifying an array element of the states data to add the results of each iteration
     * 
     */
    @JsonProperty("outputCollection")
    public java.lang.String getOutputCollection() {
        return outputCollection;
    }

    /**
     * Workflow expression specifying an array element of the states data to add the results of each iteration
     * 
     */
    @JsonProperty("outputCollection")
    public void setOutputCollection(java.lang.String outputCollection) {
        this.outputCollection = outputCollection;
    }

    public ForEachState withOutputCollection(java.lang.String outputCollection) {
        this.outputCollection = outputCollection;
        return this;
    }

    /**
     * Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array
     * 
     */
    @JsonProperty("iterationParam")
    public java.lang.String getIterationParam() {
        return iterationParam;
    }

    /**
     * Name of the iteration parameter that can be referenced in actions/workflow. For each parallel iteration, this param should contain an unique element of the inputCollection array
     * 
     */
    @JsonProperty("iterationParam")
    public void setIterationParam(java.lang.String iterationParam) {
        this.iterationParam = iterationParam;
    }

    public ForEachState withIterationParam(java.lang.String iterationParam) {
        this.iterationParam = iterationParam;
        return this;
    }

    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    public int getMax() {
        return max;
    }

    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    public void setMax(int max) {
        this.max = max;
    }

    public ForEachState withMax(int max) {
        this.max = max;
        return this;
    }

    /**
     * Actions to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Actions to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public ForEachState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Unique Id of a workflow to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("workflowId")
    public java.lang.String getWorkflowId() {
        return workflowId;
    }

    /**
     * Unique Id of a workflow to be executed for each of the elements of inputCollection
     * 
     */
    @JsonProperty("workflowId")
    public void setWorkflowId(java.lang.String workflowId) {
        this.workflowId = workflowId;
    }

    public ForEachState withWorkflowId(java.lang.String workflowId) {
        this.workflowId = workflowId;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public ForEachState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public ForEachState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ForEachState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ForEachState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ForEachState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ForEachState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ForEachState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ForEachState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public ForEachState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

}
