
package io.serverlessworkflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.error.Error;
import io.serverlessworkflow.api.filters.StateDataFilter;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.transitions.Transition;


/**
 * This state is used to wait for events from event sources and then transitioning to a next state
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "timeDelay",
    "usedForCompensation"
})
public class DelayState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    @JsonPropertyDescription("Amount of time (ISO 8601 format) to delay")
    @NotNull
    private java.lang.String timeDelay;
    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    @JsonPropertyDescription("If true, this state is used to compensate another state. Default is false")
    private boolean usedForCompensation = false;
    private final static long serialVersionUID = 4952611582741988773L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public DelayState() {
    }

    /**
     * 
     * @param name
     * @param timeDelay
     * @param type
     */
    public DelayState(java.lang.String timeDelay, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.timeDelay = timeDelay;
    }

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    public java.lang.String getTimeDelay() {
        return timeDelay;
    }

    /**
     * Amount of time (ISO 8601 format) to delay
     * (Required)
     * 
     */
    @JsonProperty("timeDelay")
    public void setTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public DelayState withTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
        return this;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public boolean isUsedForCompensation() {
        return usedForCompensation;
    }

    /**
     * If true, this state is used to compensate another state. Default is false
     * 
     */
    @JsonProperty("usedForCompensation")
    public void setUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
    }

    public DelayState withUsedForCompensation(boolean usedForCompensation) {
        this.usedForCompensation = usedForCompensation;
        return this;
    }

    @Override
    public DelayState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public DelayState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public DelayState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public DelayState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public DelayState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public DelayState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public DelayState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public DelayState withOnErrors(List<Error> onErrors) {
        super.withOnErrors(onErrors);
        return this;
    }

    @Override
    public DelayState withCompensatedBy(java.lang.String compensatedBy) {
        super.withCompensatedBy(compensatedBy);
        return this;
    }

}
