
package io.serverlessworkflow.api.functions;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "refName",
    "arguments"
})
public class FunctionRef implements Serializable
{

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    @JsonPropertyDescription("Name of the referenced function")
    @Size(min = 1)
    @NotNull
    private String refName;
    /**
     * Function arguments
     * 
     */
    @JsonProperty("arguments")
    @JsonPropertyDescription("Function arguments")
    @Valid
    private JsonNode arguments;
    private final static long serialVersionUID = 4854642605762609360L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public FunctionRef() {
    }

    /**
     * 
     * @param refName
     */
    public FunctionRef(String refName) {
        super();
        this.refName = refName;
    }

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    public String getRefName() {
        return refName;
    }

    /**
     * Name of the referenced function
     * (Required)
     * 
     */
    @JsonProperty("refName")
    public void setRefName(String refName) {
        this.refName = refName;
    }

    public FunctionRef withRefName(String refName) {
        this.refName = refName;
        return this;
    }

    /**
     * Function arguments
     * 
     */
    @JsonProperty("arguments")
    public JsonNode getArguments() {
        return arguments;
    }

    /**
     * Function arguments
     * 
     */
    @JsonProperty("arguments")
    public void setArguments(JsonNode arguments) {
        this.arguments = arguments;
    }

    public FunctionRef withArguments(JsonNode arguments) {
        this.arguments = arguments;
        return this;
    }

}
