
package io.serverlessworkflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "input",
    "output"
})
public class StateDataFilter implements Serializable
{

    /**
     * Workflow expression to filter the state data input
     * 
     */
    @JsonProperty("input")
    @JsonPropertyDescription("Workflow expression to filter the state data input")
    private String input;
    /**
     * Workflow expression that filters the state data output
     * 
     */
    @JsonProperty("output")
    @JsonPropertyDescription("Workflow expression that filters the state data output")
    private String output;
    private final static long serialVersionUID = 239309000496960765L;

    /**
     * Workflow expression to filter the state data input
     * 
     */
    @JsonProperty("input")
    public String getInput() {
        return input;
    }

    /**
     * Workflow expression to filter the state data input
     * 
     */
    @JsonProperty("input")
    public void setInput(String input) {
        this.input = input;
    }

    public StateDataFilter withInput(String input) {
        this.input = input;
        return this;
    }

    /**
     * Workflow expression that filters the state data output
     * 
     */
    @JsonProperty("output")
    public String getOutput() {
        return output;
    }

    /**
     * Workflow expression that filters the state data output
     * 
     */
    @JsonProperty("output")
    public void setOutput(String output) {
        this.output = output;
    }

    public StateDataFilter withOutput(String output) {
        this.output = output;
        return this;
    }

}
