
package io.serverlessworkflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "data",
    "toStateData"
})
public class EventDataFilter implements Serializable
{

    /**
     * Workflow expression that filters of the event data (payload)
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("Workflow expression that filters of the event data (payload)")
    private String data;
    /**
     *  Workflow expression that selects a state data element to which the event payload should be added/merged into. If not specified, denotes, the top-level state data element.
     * 
     */
    @JsonProperty("toStateData")
    @JsonPropertyDescription(" Workflow expression that selects a state data element to which the event payload should be added/merged into. If not specified, denotes, the top-level state data element.")
    private String toStateData;
    private final static long serialVersionUID = 1833212229401556752L;

    /**
     * Workflow expression that filters of the event data (payload)
     * 
     */
    @JsonProperty("data")
    public String getData() {
        return data;
    }

    /**
     * Workflow expression that filters of the event data (payload)
     * 
     */
    @JsonProperty("data")
    public void setData(String data) {
        this.data = data;
    }

    public EventDataFilter withData(String data) {
        this.data = data;
        return this;
    }

    /**
     *  Workflow expression that selects a state data element to which the event payload should be added/merged into. If not specified, denotes, the top-level state data element.
     * 
     */
    @JsonProperty("toStateData")
    public String getToStateData() {
        return toStateData;
    }

    /**
     *  Workflow expression that selects a state data element to which the event payload should be added/merged into. If not specified, denotes, the top-level state data element.
     * 
     */
    @JsonProperty("toStateData")
    public void setToStateData(String toStateData) {
        this.toStateData = toStateData;
    }

    public EventDataFilter withToStateData(String toStateData) {
        this.toStateData = toStateData;
        return this;
    }

}
