
package io.serverlessworkflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "fromStateData",
    "results",
    "toStateData"
})
public class ActionDataFilter implements Serializable
{

    /**
     * Workflow expression that selects state data that the state action can use
     * 
     */
    @JsonProperty("fromStateData")
    @JsonPropertyDescription("Workflow expression that selects state data that the state action can use")
    private String fromStateData;
    /**
     * Workflow expression that filters the actions data results
     * 
     */
    @JsonProperty("results")
    @JsonPropertyDescription("Workflow expression that filters the actions data results")
    private String results;
    /**
     * Workflow expression that selects a state data element to which the action results should be added/merged into. If not specified, denote, the top-level state data element
     * 
     */
    @JsonProperty("toStateData")
    @JsonPropertyDescription("Workflow expression that selects a state data element to which the action results should be added/merged into. If not specified, denote, the top-level state data element")
    private String toStateData;
    private final static long serialVersionUID = -1377110258549982782L;

    /**
     * Workflow expression that selects state data that the state action can use
     * 
     */
    @JsonProperty("fromStateData")
    public String getFromStateData() {
        return fromStateData;
    }

    /**
     * Workflow expression that selects state data that the state action can use
     * 
     */
    @JsonProperty("fromStateData")
    public void setFromStateData(String fromStateData) {
        this.fromStateData = fromStateData;
    }

    public ActionDataFilter withFromStateData(String fromStateData) {
        this.fromStateData = fromStateData;
        return this;
    }

    /**
     * Workflow expression that filters the actions data results
     * 
     */
    @JsonProperty("results")
    public String getResults() {
        return results;
    }

    /**
     * Workflow expression that filters the actions data results
     * 
     */
    @JsonProperty("results")
    public void setResults(String results) {
        this.results = results;
    }

    public ActionDataFilter withResults(String results) {
        this.results = results;
        return this;
    }

    /**
     * Workflow expression that selects a state data element to which the action results should be added/merged into. If not specified, denote, the top-level state data element
     * 
     */
    @JsonProperty("toStateData")
    public String getToStateData() {
        return toStateData;
    }

    /**
     * Workflow expression that selects a state data element to which the action results should be added/merged into. If not specified, denote, the top-level state data element
     * 
     */
    @JsonProperty("toStateData")
    public void setToStateData(String toStateData) {
        this.toStateData = toStateData;
    }

    public ActionDataFilter withToStateData(String toStateData) {
        this.toStateData = toStateData;
        return this;
    }

}
