
package io.serverlessworkflow.api.error;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.end.End;
import io.serverlessworkflow.api.transitions.Transition;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "error",
    "code",
    "retryRef",
    "transition",
    "end"
})
public class Error implements Serializable
{

    /**
     * Domain-specific error name, or '*' to indicate all possible errors
     * (Required)
     * 
     */
    @JsonProperty("error")
    @JsonPropertyDescription("Domain-specific error name, or '*' to indicate all possible errors")
    @Size(min = 1)
    @NotNull
    private String error;
    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    @JsonPropertyDescription("Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'")
    @Size(min = 1)
    private String code;
    /**
     * References a unique name of a retry definition.
     * 
     */
    @JsonProperty("retryRef")
    @JsonPropertyDescription("References a unique name of a retry definition.")
    @Size(min = 1)
    private String retryRef;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    @JsonPropertyDescription("State end definition")
    @Valid
    private End end;
    private final static long serialVersionUID = -8933996684263594192L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Error() {
    }

    /**
     * 
     * @param error
     * @param transition
     */
    public Error(String error, Transition transition) {
        super();
        this.error = error;
        this.transition = transition;
    }

    /**
     * Domain-specific error name, or '*' to indicate all possible errors
     * (Required)
     * 
     */
    @JsonProperty("error")
    public String getError() {
        return error;
    }

    /**
     * Domain-specific error name, or '*' to indicate all possible errors
     * (Required)
     * 
     */
    @JsonProperty("error")
    public void setError(String error) {
        this.error = error;
    }

    public Error withError(String error) {
        this.error = error;
        return this;
    }

    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    /**
     * Error code. Can be used in addition to the name to help runtimes resolve to technical errors/exceptions. Should not be defined if error is set to '*'
     * 
     */
    @JsonProperty("code")
    public void setCode(String code) {
        this.code = code;
    }

    public Error withCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * References a unique name of a retry definition.
     * 
     */
    @JsonProperty("retryRef")
    public String getRetryRef() {
        return retryRef;
    }

    /**
     * References a unique name of a retry definition.
     * 
     */
    @JsonProperty("retryRef")
    public void setRetryRef(String retryRef) {
        this.retryRef = retryRef;
    }

    public Error withRetryRef(String retryRef) {
        this.retryRef = retryRef;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public Error withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public End getEnd() {
        return end;
    }

    /**
     * State end definition
     * 
     */
    @JsonProperty("end")
    public void setEnd(End end) {
        this.end = end;
    }

    public Error withEnd(End end) {
        this.end = end;
        return this;
    }

}
