
package io.serverlessworkflow.api.actions;

import java.io.Serializable;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.events.EventRef;
import io.serverlessworkflow.api.filters.ActionDataFilter;
import io.serverlessworkflow.api.functions.FunctionRef;


/**
 * Action Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "functionRef",
    "eventRef",
    "timeout",
    "actionDataFilter"
})
public class Action implements Serializable
{

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique action definition name")
    private String name;
    @JsonProperty("functionRef")
    @Valid
    private FunctionRef functionRef;
    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    @JsonPropertyDescription("Event References")
    @Valid
    private EventRef eventRef;
    /**
     * Time period to wait for function execution to complete
     * 
     */
    @JsonProperty("timeout")
    @JsonPropertyDescription("Time period to wait for function execution to complete")
    private String timeout;
    @JsonProperty("actionDataFilter")
    @Valid
    private ActionDataFilter actionDataFilter;
    private final static long serialVersionUID = -3320226187272802466L;

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("functionRef")
    public FunctionRef getFunctionRef() {
        return functionRef;
    }

    @JsonProperty("functionRef")
    public void setFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    public Action withFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
        return this;
    }

    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    public EventRef getEventRef() {
        return eventRef;
    }

    /**
     * Event References
     * 
     */
    @JsonProperty("eventRef")
    public void setEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
    }

    public Action withEventRef(EventRef eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    /**
     * Time period to wait for function execution to complete
     * 
     */
    @JsonProperty("timeout")
    public String getTimeout() {
        return timeout;
    }

    /**
     * Time period to wait for function execution to complete
     * 
     */
    @JsonProperty("timeout")
    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public Action withTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    @JsonProperty("actionDataFilter")
    public ActionDataFilter getActionDataFilter() {
        return actionDataFilter;
    }

    @JsonProperty("actionDataFilter")
    public void setActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
    }

    public Action withActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
        return this;
    }

}
