
package io.serverlessworkflow.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.serverlessworkflow.api.exectimeout.ExecTimeout;
import io.serverlessworkflow.api.interfaces.Extension;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.workflow.BaseWorkflow;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import io.serverlessworkflow.api.workflow.Retries;


/**
 * Serverless Workflow is a vendor-neutral specification for defining the model of workflows responsible for orchestrating event-driven serverless applications.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "description",
    "version",
    "start",
    "schemaVersion",
    "expressionLang",
    "execTimeout",
    "keepActive",
    "metadata",
    "events",
    "functions",
    "retries",
    "states",
    "extensions"
})
public class Workflow
    extends BaseWorkflow
    implements Serializable
{

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("Workflow unique identifier")
    @Size(min = 1)
    @NotNull
    private java.lang.String id;
    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Workflow name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Workflow description")
    private java.lang.String description;
    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    @JsonPropertyDescription("Workflow version")
    @NotNull
    private java.lang.String version;
    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    @JsonPropertyDescription("State start definition")
    @Valid
    private Start start;
    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    @JsonPropertyDescription("Serverless Workflow schema version")
    private java.lang.String schemaVersion;
    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    @JsonPropertyDescription("Identifies the expression language used for workflow expressions. Default is 'jq'")
    @Size(min = 1)
    private java.lang.String expressionLang = "jq";
    @JsonProperty("execTimeout")
    @Valid
    private ExecTimeout execTimeout;
    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    @JsonPropertyDescription("If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'")
    private boolean keepActive = false;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    @JsonPropertyDescription("Workflow event definitions")
    @Valid
    private Events events;
    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    @JsonPropertyDescription("Workflow function definitions")
    @Valid
    private Functions functions;
    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    @JsonPropertyDescription("Workflow retry definitions")
    @Valid
    private Retries retries;
    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    @JsonPropertyDescription("State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    @JsonPropertyDescription("Workflow Extensions")
    @Valid
    private List<Extension> extensions = new ArrayList<Extension>();
    private final static long serialVersionUID = -6120985004957658044L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Workflow() {
    }

    /**
     * 
     * @param name
     * @param id
     * @param version
     * @param states
     */
    public Workflow(java.lang.String id, java.lang.String name, java.lang.String version, List<State> states) {
        super();
        this.id = id;
        this.name = name;
        this.version = version;
        this.states = states;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    public Workflow withId(java.lang.String id) {
        this.id = id;
        return this;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public Workflow withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public java.lang.String getDescription() {
        return description;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    public Workflow withDescription(java.lang.String description) {
        this.description = description;
        return this;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public java.lang.String getVersion() {
        return version;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

    public Workflow withVersion(java.lang.String version) {
        this.version = version;
        return this;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public Start getStart() {
        return start;
    }

    /**
     * State start definition
     * 
     */
    @JsonProperty("start")
    public void setStart(Start start) {
        this.start = start;
    }

    public Workflow withStart(Start start) {
        this.start = start;
        return this;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    public java.lang.String getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    public void setSchemaVersion(java.lang.String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Workflow withSchemaVersion(java.lang.String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    public java.lang.String getExpressionLang() {
        return expressionLang;
    }

    /**
     * Identifies the expression language used for workflow expressions. Default is 'jq'
     * 
     */
    @JsonProperty("expressionLang")
    public void setExpressionLang(java.lang.String expressionLang) {
        this.expressionLang = expressionLang;
    }

    public Workflow withExpressionLang(java.lang.String expressionLang) {
        this.expressionLang = expressionLang;
        return this;
    }

    @JsonProperty("execTimeout")
    public ExecTimeout getExecTimeout() {
        return execTimeout;
    }

    @JsonProperty("execTimeout")
    public void setExecTimeout(ExecTimeout execTimeout) {
        this.execTimeout = execTimeout;
    }

    public Workflow withExecTimeout(ExecTimeout execTimeout) {
        this.execTimeout = execTimeout;
        return this;
    }

    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    public boolean isKeepActive() {
        return keepActive;
    }

    /**
     * If 'true', workflow instances is not terminated when there are no active execution paths. Instance can be terminated via 'terminate end definition' or reaching defined 'execTimeout'
     * 
     */
    @JsonProperty("keepActive")
    public void setKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
    }

    public Workflow withKeepActive(boolean keepActive) {
        this.keepActive = keepActive;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Workflow withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    public Events getEvents() {
        return events;
    }

    /**
     * Workflow event definitions
     * 
     */
    @JsonProperty("events")
    public void setEvents(Events events) {
        this.events = events;
    }

    public Workflow withEvents(Events events) {
        this.events = events;
        return this;
    }

    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    public Functions getFunctions() {
        return functions;
    }

    /**
     * Workflow function definitions
     * 
     */
    @JsonProperty("functions")
    public void setFunctions(Functions functions) {
        this.functions = functions;
    }

    public Workflow withFunctions(Functions functions) {
        this.functions = functions;
        return this;
    }

    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    public Retries getRetries() {
        return retries;
    }

    /**
     * Workflow retry definitions
     * 
     */
    @JsonProperty("retries")
    public void setRetries(Retries retries) {
        this.retries = retries;
    }

    public Workflow withRetries(Retries retries) {
        this.retries = retries;
        return this;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public List<State> getStates() {
        return states;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Workflow withStates(List<State> states) {
        this.states = states;
        return this;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public List<Extension> getExtensions() {
        return extensions;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public Workflow withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

}
