/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.postgresql.internal;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.postgresql.extension.CodecRegistrar;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Configs;
import io.rxmicro.data.sql.r2dbc.postgresql.PostgreSQLConfig;
import io.rxmicro.data.sql.r2dbc.postgresql.internal.RxMicroLoopResources;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.netty.runtime.local.EventLoopGroupFactory;
import io.rxmicro.runtime.AutoRelease;
import io.rxmicro.runtime.local.InstanceContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.resources.LoopResources;

public final class PostgreSQLConnectionPoolBuilder {
    private static final String POSTGRE_SQL_THREAD_NAME_QUALIFIER = "postgre-sql";
    private static final PostgreSQLConnectionPoolBuilder INSTANCE = new PostgreSQLConnectionPoolBuilder();
    private final List<CodecRegistrar> codecRegistrars = new ArrayList<CodecRegistrar>();
    private Function<Connection, Connection> connectionDecorator;
    private PostgreSQLConnectionPool postgreSQLConnectionPool;

    public static PostgreSQLConnectionPoolBuilder getInstance() {
        return INSTANCE;
    }

    private PostgreSQLConnectionPoolBuilder() {
    }

    public void addCodecRegistrar(CodecRegistrar codecRegistrar) {
        this.validateState();
        this.codecRegistrars.add((CodecRegistrar)Requires.require((Object)codecRegistrar));
    }

    public void setConnectionDecorator(Function<Connection, Connection> connectionDecorator) {
        this.validateState();
        this.connectionDecorator = (Function)Requires.require(connectionDecorator);
    }

    public ConnectionPool build(String namespace) {
        this.validateState();
        PostgreSQLConfig postgreSQLConfig = (PostgreSQLConfig)Configs.getConfig((String)namespace, PostgreSQLConfig.class);
        ConnectionFactory connectionFactory = this.createConnectionFactory(postgreSQLConfig);
        return this.createConnectionPool(postgreSQLConfig, connectionFactory);
    }

    private void validateState() {
        if (this.postgreSQLConnectionPool != null) {
            throw new IllegalStateException("Connection pool already built! Any customizations must be done before building of the connection pool!");
        }
    }

    private ConnectionFactory createConnectionFactory(PostgreSQLConfig postgreSQLConfig) {
        PostgresqlConnectionConfiguration.Builder builder = PostgresqlConnectionConfiguration.builder().host(postgreSQLConfig.getHost()).port(postgreSQLConfig.getPort()).username(postgreSQLConfig.getUser()).password(postgreSQLConfig.getPassword()).database(postgreSQLConfig.getDatabase()).connectTimeout(postgreSQLConfig.getConnectTimeout()).loopResources((LoopResources)new RxMicroLoopResources(EventLoopGroupFactory.getEventLoopGroupFactory().getRequiredWorkerEventLoopGroup(POSTGRE_SQL_THREAD_NAME_QUALIFIER)));
        this.codecRegistrars.forEach(arg_0 -> ((PostgresqlConnectionConfiguration.Builder)builder).codecRegistrar(arg_0));
        postgreSQLConfig.getOptions().ifPresent(arg_0 -> ((PostgresqlConnectionConfiguration.Builder)builder).options(arg_0));
        return new PostgresqlConnectionFactory(builder.build());
    }

    private ConnectionPool createConnectionPool(PostgreSQLConfig postgreSQLConfig, ConnectionFactory connectionFactory) {
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).name("rxmicro-postgresql-connection-pool").acquireRetry(postgreSQLConfig.getAcquireRetry()).initialSize(postgreSQLConfig.getInitialSize()).maxSize(postgreSQLConfig.getMaxSize()).validationQuery(postgreSQLConfig.getValidationQuery()).maxAcquireTime(postgreSQLConfig.getMaxAcquireTime()).maxCreateConnectionTime(postgreSQLConfig.getMaxCreateConnectionTime()).maxIdleTime(postgreSQLConfig.getMaxIdleTime()).maxLifeTime(postgreSQLConfig.getMaxLifeTime());
        ConnectionPool connectionPool = this.buildConnectionPool(builder);
        this.postgreSQLConnectionPool = new PostgreSQLConnectionPool(this, postgreSQLConfig, connectionPool);
        return connectionPool;
    }

    private ConnectionPool buildConnectionPool(ConnectionPoolConfiguration.Builder builder) {
        return Optional.ofNullable(this.connectionDecorator).map(decorator -> new ConnectionPool(builder.build(), (Function)decorator){
            final /* synthetic */ Function val$decorator;
            {
                this.val$decorator = function;
                super(arg0);
            }

            public Mono<Connection> create() {
                return super.create().map(this.val$decorator);
            }
        }).orElseGet(() -> new ConnectionPool(builder.build()));
    }

    private static final class PostgreSQLConnectionPool
    implements AutoRelease {
        private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLConnectionPool.class);
        private final PostgreSQLConnectionPoolBuilder builder;
        private final PostgreSQLConfig postgreSQLConfig;
        private final ConnectionPool connectionPool;

        private PostgreSQLConnectionPool(PostgreSQLConnectionPoolBuilder builder, PostgreSQLConfig postgreSQLConfig, ConnectionPool connectionPool) {
            this.builder = builder;
            this.postgreSQLConfig = (PostgreSQLConfig)((Object)Requires.require((Object)((Object)postgreSQLConfig)));
            this.connectionPool = (ConnectionPool)Requires.require((Object)connectionPool);
            LOGGER.info("Pool created: connectionString='?', poolSize:{init=?, max=?}", (Object)postgreSQLConfig.getConnectionString(), (Object)postgreSQLConfig.getInitialSize(), (Object)postgreSQLConfig.getMaxSize());
            InstanceContainer.registerAutoRelease((AutoRelease)this);
        }

        public void release() {
            this.connectionPool.dispose();
            LOGGER.info("Pool disposed: connectionString='?'", (Object)this.postgreSQLConfig.getConnectionString());
            this.builder.postgreSQLConnectionPool = null;
        }
    }
}

