/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.postgresql.internal;

import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.pool.ConnectionPoolConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionConfiguration;
import io.r2dbc.postgresql.PostgresqlConnectionFactory;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import io.rxmicro.common.util.Formats;
import io.rxmicro.common.util.Requires;
import io.rxmicro.config.Configs;
import io.rxmicro.data.sql.r2dbc.postgresql.PostgreSQLConfig;
import io.rxmicro.logger.Logger;
import io.rxmicro.logger.LoggerFactory;
import io.rxmicro.runtime.AutoRelease;
import io.rxmicro.runtime.local.InstanceContainer;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class PostgreSQLConnectionPoolBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Formats.format((String)"?.PostgreSQLPooledClient", (Object[])new Object[]{PostgreSQLConnectionPoolBuilder.class.getPackageName()}));

    public ConnectionPool createConnectionPool(String nameSpace) {
        PostgreSQLConfig postgreSQLConfig = (PostgreSQLConfig)Configs.getConfig((String)nameSpace, PostgreSQLConfig.class);
        ConnectionFactory connectionFactory = this.createConnectionFactory(postgreSQLConfig);
        return this.createConnectionPool(postgreSQLConfig, connectionFactory);
    }

    private ConnectionFactory createConnectionFactory(PostgreSQLConfig postgreSQLConfig) {
        PostgresqlConnectionConfiguration.Builder builder = PostgresqlConnectionConfiguration.builder().host(postgreSQLConfig.getHost()).port(postgreSQLConfig.getPort()).username(postgreSQLConfig.getUser()).password(postgreSQLConfig.getPassword()).database(postgreSQLConfig.getDatabase()).connectTimeout(postgreSQLConfig.getConnectTimeout());
        postgreSQLConfig.getOptions().ifPresent(arg_0 -> ((PostgresqlConnectionConfiguration.Builder)builder).options(arg_0));
        return new PostgresqlConnectionFactory(builder.build());
    }

    private ConnectionPool createConnectionPool(PostgreSQLConfig postgreSQLConfig, ConnectionFactory connectionFactory) {
        ConnectionPoolConfiguration.Builder builder = ConnectionPoolConfiguration.builder((ConnectionFactory)connectionFactory).name("rxmicro-postgresql-connection-pool").acquireRetry(postgreSQLConfig.getAcquireRetry()).initialSize(postgreSQLConfig.getInitialSize()).maxSize(postgreSQLConfig.getMaxSize()).validationQuery(postgreSQLConfig.getValidationQuery()).maxAcquireTime(postgreSQLConfig.getMaxAcquireTime()).maxCreateConnectionTime(postgreSQLConfig.getMaxCreateConnectionTime()).maxIdleTime(postgreSQLConfig.getMaxIdleTime()).maxLifeTime(postgreSQLConfig.getMaxLifeTime());
        ConnectionPool connectionPool = this.buildConnectionPool(postgreSQLConfig, builder);
        LOGGER.info("PostgreSQL pooled client created: connectionString='?', poolSize:{init=?, max=?}", (Object)postgreSQLConfig.getConnectionString(), (Object)postgreSQLConfig.getInitialSize(), (Object)postgreSQLConfig.getMaxSize());
        InstanceContainer.registerAutoRelease((AutoRelease)new R2DBCPostgreSQLConnectionPool(postgreSQLConfig, connectionPool));
        return connectionPool;
    }

    private ConnectionPool buildConnectionPool(PostgreSQLConfig postgreSQLConfig, ConnectionPoolConfiguration.Builder builder) {
        return postgreSQLConfig.getConnectionDecorator().map(decorator -> new ConnectionPool(builder.build(), (Function)decorator){
            final /* synthetic */ Function val$decorator;
            {
                this.val$decorator = function;
                super(arg0);
            }

            public Mono<Connection> create() {
                return super.create().map(this.val$decorator);
            }
        }).orElseGet(() -> new ConnectionPool(builder.build()));
    }

    private static final class R2DBCPostgreSQLConnectionPool
    implements AutoRelease {
        private final PostgreSQLConfig postgreSQLConfig;
        private final ConnectionPool connectionPool;

        private R2DBCPostgreSQLConnectionPool(PostgreSQLConfig postgreSQLConfig, ConnectionPool connectionPool) {
            this.postgreSQLConfig = (PostgreSQLConfig)((Object)Requires.require((Object)((Object)postgreSQLConfig)));
            this.connectionPool = (ConnectionPool)Requires.require((Object)connectionPool);
        }

        public void release() {
            this.connectionPool.dispose();
            LOGGER.info("PostgreSQL pooled client closed: connectionString='?'", (Object)this.postgreSQLConfig.getConnectionString());
        }
    }
}

