/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.data.sql.r2dbc.postgresql;

import io.r2dbc.spi.Connection;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.SQLPooledDatabaseConfig;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Function;

public final class PostgreSQLConfig
extends SQLPooledDatabaseConfig {
    private Function<Connection, Connection> connectionDecorator;

    public PostgreSQLConfig() {
        this.setPort(5432);
        this.setUser("rxmicro");
    }

    public String getConnectionString() {
        return Formats.format((String)"r2dbc:postgresql://?:?/?", (Object[])new Object[]{this.getHost(), this.getPort(), this.getDatabase()});
    }

    public PostgreSQLConfig setAcquireRetry(int acquireRetry) {
        return (PostgreSQLConfig)super.setAcquireRetry(acquireRetry);
    }

    public PostgreSQLConfig setInitialSize(int initialSize) {
        return (PostgreSQLConfig)super.setInitialSize(initialSize);
    }

    public PostgreSQLConfig setMaxSize(int maxSize) {
        return (PostgreSQLConfig)super.setMaxSize(maxSize);
    }

    public PostgreSQLConfig setValidationQuery(String validationQuery) {
        return (PostgreSQLConfig)super.setValidationQuery(validationQuery);
    }

    public PostgreSQLConfig setMaxIdleTime(Duration maxIdleTime) {
        return (PostgreSQLConfig)super.setMaxIdleTime(maxIdleTime);
    }

    public PostgreSQLConfig setMaxCreateConnectionTime(Duration maxCreateConnectionTime) {
        return (PostgreSQLConfig)super.setMaxCreateConnectionTime(maxCreateConnectionTime);
    }

    public PostgreSQLConfig setMaxAcquireTime(Duration maxAcquireTime) {
        return (PostgreSQLConfig)super.setMaxAcquireTime(maxAcquireTime);
    }

    public PostgreSQLConfig setMaxLifeTime(Duration maxLifeTime) {
        return (PostgreSQLConfig)super.setMaxLifeTime(maxLifeTime);
    }

    public PostgreSQLConfig setHost(String host) {
        return (PostgreSQLConfig)super.setHost(host);
    }

    public PostgreSQLConfig setPort(int port) {
        return (PostgreSQLConfig)super.setPort(port);
    }

    public PostgreSQLConfig setUser(String user) {
        return (PostgreSQLConfig)super.setUser(user);
    }

    public PostgreSQLConfig setPassword(CharSequence password) {
        return (PostgreSQLConfig)super.setPassword(password);
    }

    public PostgreSQLConfig setDatabase(String database) {
        return (PostgreSQLConfig)super.setDatabase(database);
    }

    public PostgreSQLConfig addOption(String name, String value) {
        return (PostgreSQLConfig)super.addOption(name, value);
    }

    public PostgreSQLConfig setConnectTimeout(Duration connectTimeout) {
        return (PostgreSQLConfig)super.setConnectTimeout(connectTimeout);
    }

    public Optional<Function<Connection, Connection>> getConnectionDecorator() {
        return Optional.ofNullable(this.connectionDecorator);
    }

    public PostgreSQLConfig setConnectionDecorator(Function<Connection, Connection> connectionDecorator) {
        this.connectionDecorator = connectionDecorator;
        return this;
    }
}

