/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.rest.model.AbstractModelJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.converter.ModelFromJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.converter.ModelToJsonConverterClassStructure;
import io.rxmicro.annotation.processor.rest.model.validator.ModelValidatorClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.AbstractRestControllerModelClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.ModelReaderClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.ModelWriterClassStructure;
import io.rxmicro.common.util.Requires;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RestControllerClassStructureStorage {
    private final Map<String, ModelValidatorClassStructure> requestValidatorMap;
    private final Map<String, ModelValidatorClassStructure> responseValidatorMap;
    private final Map<String, ModelReaderClassStructure> modelReaderMap;
    private final Map<String, ModelWriterClassStructure> modelWriterMap;
    private final Map<String, ModelFromJsonConverterClassStructure> modelFromJsonConverterMap;
    private final Map<String, ModelToJsonConverterClassStructure> modelToJsonConverterMap;

    private RestControllerClassStructureStorage(Map<String, ModelValidatorClassStructure> requestValidatorMap, Map<String, ModelValidatorClassStructure> responseValidatorMap, Map<String, ModelReaderClassStructure> modelReaderMap, Map<String, ModelWriterClassStructure> modelWriterMap, Map<String, ModelFromJsonConverterClassStructure> modelFromJsonConverterMap, Map<String, ModelToJsonConverterClassStructure> modelToJsonConverterMap) {
        this.requestValidatorMap = (Map)Requires.require(requestValidatorMap);
        this.responseValidatorMap = (Map)Requires.require(responseValidatorMap);
        this.modelReaderMap = (Map)Requires.require(modelReaderMap);
        this.modelWriterMap = (Map)Requires.require(modelWriterMap);
        this.modelFromJsonConverterMap = (Map)Requires.require(modelFromJsonConverterMap);
        this.modelToJsonConverterMap = (Map)Requires.require(modelToJsonConverterMap);
    }

    public boolean isRequestValidatorPresent(String fullClassName) {
        return this.requestValidatorMap.containsKey(fullClassName);
    }

    public boolean isRequestValidatorsPresent() {
        return !this.requestValidatorMap.isEmpty();
    }

    public boolean isResponseValidatorPresent(String fullClassName) {
        return this.responseValidatorMap.containsKey(fullClassName);
    }

    public boolean isResponseValidatorsPresent() {
        return !this.responseValidatorMap.isEmpty();
    }

    public Optional<ModelReaderClassStructure> getModelReaderClassStructure(String fullClassName) {
        return Optional.ofNullable(this.modelReaderMap.get(fullClassName));
    }

    public Optional<ModelWriterClassStructure> getModelWriterClassStructure(String fullClassName) {
        return Optional.ofNullable(this.modelWriterMap.get(fullClassName));
    }

    public Set<ClassStructure> getAll() {
        return Stream.of(this.requestValidatorMap.values().stream().map(s -> s), this.responseValidatorMap.values().stream().map(s -> s), this.modelReaderMap.values().stream().map(s -> s), this.modelWriterMap.values().stream().map(s -> s), this.modelFromJsonConverterMap.values().stream().map(s -> s), this.modelToJsonConverterMap.values().stream().map(s -> s)).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public static final class Builder {
        private final Set<ModelValidatorClassStructure> requestValidators = new HashSet<ModelValidatorClassStructure>();
        private final Set<ModelValidatorClassStructure> responseValidators = new HashSet<ModelValidatorClassStructure>();
        private final Set<ModelReaderClassStructure> modelReaders = new HashSet<ModelReaderClassStructure>();
        private final Set<ModelWriterClassStructure> modelWriters = new HashSet<ModelWriterClassStructure>();
        private final Set<ModelFromJsonConverterClassStructure> modelFromJsonConverters = new HashSet<ModelFromJsonConverterClassStructure>();
        private final Set<ModelToJsonConverterClassStructure> modelToJsonConverters = new HashSet<ModelToJsonConverterClassStructure>();

        public void addRequestValidators(Set<ModelValidatorClassStructure> requestValidators) {
            this.requestValidators.addAll(requestValidators);
        }

        public void addResponseValidators(Set<ModelValidatorClassStructure> responseValidators) {
            this.responseValidators.addAll(responseValidators);
        }

        public Builder addModelReaders(Set<ModelReaderClassStructure> modelReaders) {
            this.modelReaders.addAll(modelReaders);
            return this;
        }

        public Builder addModelWriters(Set<ModelWriterClassStructure> modelWriters) {
            this.modelWriters.addAll(modelWriters);
            return this;
        }

        public Builder addModelFromJsonConverters(Set<ModelFromJsonConverterClassStructure> modelFromJsonConverters) {
            this.modelFromJsonConverters.addAll(modelFromJsonConverters);
            return this;
        }

        public Builder addModelToJsonConverters(Set<ModelToJsonConverterClassStructure> modelToJsonConverters) {
            this.modelToJsonConverters.addAll(modelToJsonConverters);
            return this;
        }

        public RestControllerClassStructureStorage build() {
            return new RestControllerClassStructureStorage(this.requestValidators.stream().collect(Collectors.toMap(ModelValidatorClassStructure::getModelFullClassName, Function.identity())), this.responseValidators.stream().collect(Collectors.toMap(ModelValidatorClassStructure::getModelFullClassName, Function.identity())), this.modelReaders.stream().collect(Collectors.toMap(AbstractRestControllerModelClassStructure::getModelFullClassName, Function.identity())), this.modelWriters.stream().collect(Collectors.toMap(AbstractRestControllerModelClassStructure::getModelFullClassName, Function.identity())), this.modelFromJsonConverters.stream().collect(Collectors.toMap(AbstractModelJsonConverterClassStructure::getModelFullClassName, Function.identity())), this.modelToJsonConverters.stream().collect(Collectors.toMap(AbstractModelJsonConverterClassStructure::getModelFullClassName, Function.identity())));
        }
    }
}

