/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.util.GeneratedClassNames;
import io.rxmicro.annotation.processor.rest.server.model.HttpHealthCheck;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.common.RxMicroModule;
import io.rxmicro.common.util.Requires;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.detail.component.AbstractRestController;
import io.rxmicro.rest.server.detail.component.BadHttpRequestRestController;
import io.rxmicro.rest.server.detail.component.CrossOriginResourceSharingPreflightRestController;
import io.rxmicro.rest.server.detail.component.HttpHealthCheckRestController;
import io.rxmicro.rest.server.detail.component.RestControllerAggregator;
import io.rxmicro.rest.server.detail.model.CrossOriginResourceSharingResource;
import io.rxmicro.rest.server.detail.model.HttpHealthCheckRegistration;
import io.rxmicro.rest.server.detail.model.mapping.ExactUrlRequestMappingRule;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class RestControllerAggregatorClassStructure
extends ClassStructure {
    private final Collection<RestControllerClassStructure> classStructures;
    private final Set<CrossOriginResourceSharingResource> crossOriginResourceSharingResources;
    private final Set<HttpHealthCheck> httpHealthChecks;
    private final boolean isRestServerNetty;

    public RestControllerAggregatorClassStructure(EnvironmentContext environmentContext, Collection<RestControllerClassStructure> classStructures, Set<CrossOriginResourceSharingResource> resources, Set<HttpHealthCheck> httpHealthChecks) {
        this.crossOriginResourceSharingResources = (Set)Requires.require(resources);
        this.httpHealthChecks = (Set)Requires.require(httpHealthChecks);
        this.classStructures = new TreeSet<RestControllerClassStructure>(Comparator.comparing(RestControllerClassStructure::getTargetFullClassName));
        this.classStructures.addAll((Collection)Requires.require(classStructures));
        this.isRestServerNetty = environmentContext.isRxMicroModuleEnabled(RxMicroModule.RX_MICRO_REST_SERVER_NETTY_MODULE);
    }

    public String getTargetFullClassName() {
        return GeneratedClassNames.getEntryPointFullClassName((String)RestControllerAggregator.REST_CONTROLLER_AGGREGATOR_IMPL_CLASS_NAME);
    }

    public String getTemplateName() {
        return "rest/server/$$RestControllerAggregatorTemplate.javaftl";
    }

    public Map<String, Object> getTemplateVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IMPL_CLASS_NAME", RestControllerAggregator.REST_CONTROLLER_AGGREGATOR_IMPL_CLASS_NAME);
        map.put("JAVA_REST_CONTROLLER_CLASSES", this.classStructures.stream().map(RestControllerClassStructure::getTargetFullClassName).collect(Collectors.toList()));
        map.put("CORS_RESOURCES", this.crossOriginResourceSharingResources);
        map.put("HTTP_HEALTH_CHECKS", this.httpHealthChecks);
        map.put("ENVIRONMENT_CUSTOMIZER_CLASS", GeneratedClassNames.$$_ENVIRONMENT_CUSTOMIZER_SIMPLE_CLASS_NAME);
        map.put("IS_NETTY_REST_SERVER", this.isRestServerNetty);
        return map;
    }

    public ClassHeader getClassHeader() {
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((String)"rxmicro");
        if (!this.crossOriginResourceSharingResources.isEmpty()) {
            classHeaderBuilder.addImports(new Class[]{Set.class, CrossOriginResourceSharingPreflightRestController.class, CrossOriginResourceSharingResource.class, UrlSegments.class});
        }
        if (!this.httpHealthChecks.isEmpty()) {
            classHeaderBuilder.addImports(new Class[]{HttpHealthCheckRestController.class, HttpHealthCheckRegistration.class});
        }
        if (this.isRestServerNetty) {
            classHeaderBuilder.addImports(new Class[]{ExactUrlRequestMappingRule.class, BadHttpRequestRestController.class});
        }
        return classHeaderBuilder.addImports(new Class[]{AbstractRestController.class, RestControllerAggregator.class, List.class}).build();
    }
}

