/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.model.MappingStrategy;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.detail.model.CrossOriginResourceSharingResource;
import io.rxmicro.rest.server.feature.EnableCrossOriginResourceSharing;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public final class CrossOriginResourceSharingResourceProxy
extends CrossOriginResourceSharingResource {
    private CrossOriginResourceSharingResourceProxy(String uri, boolean accessControlAllowCredentials, int accessControlMaxAge, Set<String> allowOrigins, Set<String> allowMethods, Set<String> allowHeaders, Set<String> standardHeaders) {
        super(uri, accessControlAllowCredentials, accessControlMaxAge, allowOrigins, allowMethods, allowHeaders, standardHeaders);
    }

    private CrossOriginResourceSharingResourceProxy(UrlSegments urlSegments, boolean accessControlAllowCredentials, int accessControlMaxAge, Set<String> allowOrigins, Set<String> allowMethods, Set<String> allowHeaders, Set<String> standardHeaders) {
        super(urlSegments, accessControlAllowCredentials, accessControlMaxAge, allowOrigins, allowMethods, allowHeaders, standardHeaders);
    }

    public Set<String> getAllowHeaders() {
        return super.getAllowHeaders().stream().map(h -> MappingStrategy.CAPITALIZE_WITH_HYPHEN.getModelName(Arrays.asList(h.split("-")))).collect(Collectors.toSet());
    }

    public Set<String> getExposedHeaders() {
        return super.getExposedHeaders().stream().map(h -> MappingStrategy.CAPITALIZE_WITH_HYPHEN.getModelName(Arrays.asList(h.split("-")))).collect(Collectors.toSet());
    }

    public static final class Builder {
        private final boolean accessControlAllowCredentials;
        private final int accessControlMaxAge;
        private final Set<String> allowOrigins;
        private final Set<String> allowMethods = new TreeSet<String>();
        private final Set<String> allowHeaders = new TreeSet<String>();
        private final Set<String> exposedHeaders;

        public Builder(EnableCrossOriginResourceSharing enableCrossOriginResourceSharing) {
            this.accessControlAllowCredentials = enableCrossOriginResourceSharing.accessControlAllowCredentials();
            this.accessControlMaxAge = enableCrossOriginResourceSharing.accessControlMaxAge();
            this.allowOrigins = ExCollections.unmodifiableOrderedSet((Object[])enableCrossOriginResourceSharing.allowOrigins());
            this.exposedHeaders = ExCollections.unmodifiableOrderedSet((Object[])enableCrossOriginResourceSharing.exposedHeaders());
        }

        public void addMethod(String method) {
            this.allowMethods.add(method);
        }

        public void addHeader(String header) {
            this.allowHeaders.add(header);
        }

        public CrossOriginResourceSharingResourceProxy build(String uri) {
            return new CrossOriginResourceSharingResourceProxy(uri, this.accessControlAllowCredentials, this.accessControlMaxAge, this.allowOrigins, this.allowMethods, this.allowHeaders, this.exposedHeaders);
        }

        public CrossOriginResourceSharingResourceProxy build(UrlSegments urlSegments) {
            return new CrossOriginResourceSharingResourceProxy(urlSegments, this.accessControlAllowCredentials, this.accessControlMaxAge, this.allowOrigins, this.allowMethods, this.allowHeaders, this.exposedHeaders);
        }
    }
}

