/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ClassHeader;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodName;
import io.rxmicro.annotation.processor.common.util.Names;
import io.rxmicro.annotation.processor.common.util.Reactives;
import io.rxmicro.annotation.processor.rest.component.PathVariableValidator;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.StaticHeaders;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerMethodBodyBuilder;
import io.rxmicro.annotation.processor.rest.server.component.ServerCommonOptionBuilder;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.http.local.RepeatableValues;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.NotFoundMessage;
import io.rxmicro.rest.server.SetStatusCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class RestControllerClassStructureBuilderImpl
implements RestControllerClassStructureBuilder {
    @Inject
    private Set<RestControllerMethodBodyBuilder> restControllerMethodBodyBuilders;
    @Inject
    private PathVariableValidator pathVariableValidator;
    @Inject
    private ServerCommonOptionBuilder serverCommonOptionBuilder;

    @Override
    public Set<RestControllerClassStructure> build(EnvironmentContext environmentContext, RestControllerClassStructureStorage restControllerClassStructureStorage, Set<RestControllerClassSignature> classSignatures) {
        return classSignatures.stream().map(signature -> this.build(environmentContext, restControllerClassStructureStorage, (RestControllerClassSignature)((Object)signature))).collect(Collectors.toSet());
    }

    private RestControllerClassStructure build(EnvironmentContext environmentContext, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerClassSignature signature) {
        TypeElement ownerClass = signature.getTypeElement();
        List<RestControllerMethodSignature> methods = signature.getMethodSignatures();
        Set<String> overloadedMethodNames = this.getOverloadedMethodNames(methods);
        ClassHeader.Builder classHeaderBuilder = ClassHeader.newClassHeaderBuilder((String)Names.getPackageName((TypeElement)ownerClass));
        StaticHeaders staticHeaders = this.serverCommonOptionBuilder.getStaticHeaders(signature.getTypeElement(), signature.getParentUrl());
        RestServerModuleGeneratorConfig restServerModuleGeneratorConfig = (RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class);
        return new RestControllerClassStructure(restServerModuleGeneratorConfig, signature.getParentUrl(), classHeaderBuilder, ownerClass, methods.stream().map(method -> this.buildRestControllerMethod(restServerModuleGeneratorConfig, classHeaderBuilder, (RestControllerMethodSignature)method, staticHeaders, overloadedMethodNames.contains(method.getSimpleName()), restControllerClassStructureStorage)).collect(Collectors.toList()), restControllerClassStructureStorage);
    }

    private Set<String> getOverloadedMethodNames(List<RestControllerMethodSignature> methods) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (RestControllerMethodSignature method : methods) {
            List list = map.computeIfAbsent(method.getSimpleName(), n -> new ArrayList());
            list.add(method);
        }
        return map.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private RestControllerMethod buildRestControllerMethod(RestServerModuleGeneratorConfig restServerModuleGeneratorConfig, ClassHeader.Builder classHeaderBuilder, RestControllerMethodSignature methodSignature, StaticHeaders staticHeadersPerType, boolean isOverloaded, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        List<HttpMethodMapping> httpMethodMappings = methodSignature.getHttpMethodMappings();
        this.validatePathVariables(methodSignature, httpMethodMappings);
        this.validateNestedModel(methodSignature, httpMethodMappings, restControllerClassStructureStorage);
        MethodName methodName = new MethodName(methodSignature.getSimpleName(), methodSignature.getExecutableElement().getParameters().stream().map(Element::asType).collect(Collectors.toList()), isOverloaded);
        int successStatusCode = Optional.ofNullable(methodSignature.getExecutableElement().getAnnotation(SetStatusCode.class)).map(SetStatusCode::value).orElse(200);
        StaticHeaders staticHeaders = new StaticHeaders(staticHeadersPerType);
        staticHeaders.setOrAddAll((RepeatableValues)this.serverCommonOptionBuilder.getStaticHeaders(methodSignature.getExecutableElement(), methodSignature.getParentUrl()));
        MethodBody methodBody = this.buildMethodBody(restServerModuleGeneratorConfig, classHeaderBuilder, methodSignature, staticHeaders, methodName, successStatusCode, restControllerClassStructureStorage);
        boolean notFoundPossible = this.isNotFoundPossible(methodSignature);
        this.validateNotFoundPossibleState(methodSignature, notFoundPossible);
        return new RestControllerMethod(httpMethodMappings, methodSignature.getExecutableElement(), methodName, methodSignature.getRequestModel(), methodBody, methodSignature.getResponseModel(), successStatusCode, notFoundPossible);
    }

    private void validatePathVariables(RestControllerMethodSignature methodSignature, List<HttpMethodMapping> httpMethodMappings) {
        if (!methodSignature.getRequestModel().requestModelNotExists()) {
            TypeElement type = methodSignature.getRequestModel().getRequiredRequestType();
            for (HttpMethodMapping httpMethodMapping : httpMethodMappings) {
                if (httpMethodMapping.isUrlSegmentsPresent()) {
                    UrlSegments urlSegments = httpMethodMapping.getUrlSegments();
                    this.pathVariableValidator.validateThatPathVariablesNotMissingOrRedundant((Element)methodSignature.getExecutableElement(), httpMethodMapping, urlSegments, type);
                    continue;
                }
                this.pathVariableValidator.validateThatPathVariablesNotFound((Element)methodSignature.getExecutableElement(), httpMethodMapping, type);
            }
        }
    }

    private void validateNestedModel(RestControllerMethodSignature methodSignature, List<HttpMethodMapping> httpMethodMappings, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        if (!methodSignature.getRequestModel().requestModelNotExists()) {
            for (HttpMethodMapping httpMethodMapping : httpMethodMappings) {
                if (httpMethodMapping.isHttpBody() || restControllerClassStructureStorage.getModelReaderClassStructure(methodSignature.getRequestModel().getRequiredRequestType().asType().toString()).orElseThrow().getModelClass().getAllChildrenObjectModelClasses().isEmpty()) continue;
                throw new InterruptProcessingException((Element)methodSignature.getExecutableElement(), "Nested model classes not allowed for @?(\"?\")", new Object[]{httpMethodMapping.getMethod(), httpMethodMapping.getExactOrTemplateUri()});
            }
        }
    }

    private MethodBody buildMethodBody(RestServerModuleGeneratorConfig restServerModuleGeneratorConfig, ClassHeader.Builder classHeaderBuilder, RestControllerMethodSignature methodSignature, StaticHeaders staticHeaders, MethodName methodName, int successStatusCode, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        for (RestControllerMethodBodyBuilder restControllerMethodBodyBuilder : this.restControllerMethodBodyBuilders) {
            if (!restControllerMethodBodyBuilder.isSupport(methodSignature)) continue;
            return restControllerMethodBodyBuilder.build(restServerModuleGeneratorConfig, classHeaderBuilder, methodName, successStatusCode, staticHeaders, methodSignature.getRequestModel(), methodSignature.getResponseModel(), restControllerClassStructureStorage);
        }
        throw new InterruptProcessingException((Element)methodSignature.getExecutableElement(), "The RxMicro framework does not know how to generate a body of this method", new Object[0]);
    }

    private boolean isNotFoundPossible(RestControllerMethodSignature methodSignature) {
        return methodSignature.getResponseModel().getReactiveType().map(t -> Reactives.isMono((TypeMirror)t) || Reactives.isMaybe((TypeMirror)t) || Reactives.isFuture((TypeMirror)t) && methodSignature.getResponseModel().isOptional()).orElse(false);
    }

    private void validateNotFoundPossibleState(RestControllerMethodSignature methodSignature, boolean notFoundPossible) {
        NotFoundMessage notFoundMessage = methodSignature.getExecutableElement().getAnnotation(NotFoundMessage.class);
        if (notFoundMessage != null && !notFoundPossible) {
            throw new InterruptProcessingException((Element)methodSignature.getExecutableElement(), "This rest controller method does not support optional result. Thus, the '@?' annotation is redundant. Remove this annotation or change return type!", new Object[]{NotFoundMessage.class.getName()});
        }
    }
}

