/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.validators.TypeValidators;
import io.rxmicro.annotation.processor.rest.component.ParentUrlBuilder;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassSignatureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerMethodSignatureBuilder;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassSignature;
import io.rxmicro.cdi.Factory;
import io.rxmicro.cdi.local.AnnotationsSupport;
import io.rxmicro.rest.client.RestClient;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class RestControllerClassSignatureBuilderImpl
implements RestControllerClassSignatureBuilder {
    @Inject
    private ParentUrlBuilder parentUrlBuilder;
    @Inject
    private RestControllerMethodSignatureBuilder restControllerMethodSignatureBuilder;

    @Override
    public Set<RestControllerClassSignature> build(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashSet<RestControllerClassSignature> result = new HashSet<RestControllerClassSignature>();
        HashSet<String> processedTypes = new HashSet<String>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                Element candidate = element.getEnclosingElement();
                if (candidate.getKind() == ElementKind.CLASS) {
                    TypeElement restControllerClass = (TypeElement)candidate;
                    if (!environmentContext.isRxMicroClassShouldBeProcessed(restControllerClass) || !processedTypes.add(restControllerClass.asType().toString())) continue;
                    this.validateRestControllerClass(restControllerClass);
                    result.add(this.buildRestClassSignature(environmentContext, restControllerClass));
                    continue;
                }
                if (candidate.getKind() == ElementKind.INTERFACE) {
                    if (candidate.getAnnotation(RestClient.class) != null) continue;
                    throw new InterruptProcessingException(candidate, "Rest controller class must be a class! If this component is Rest client, that it must be annotated by '@?' annotation!", new Object[]{RestClient.class.getName()});
                }
                throw new InterruptProcessingException(candidate, "Rest controller class must be a class. Current element kind is: ?", new Object[]{candidate.getKind()});
            }
        }
        return result;
    }

    private void validateRestControllerClass(TypeElement restControllerClass) {
        TypeValidators.validateNotSuperClass((TypeElement)restControllerClass, (String)"Rest controller class must extend java.lang.Object class only!", (Object[])new Object[0]);
        TypeValidators.validateNotAbstractClass((TypeElement)restControllerClass, (String)"Rest controller class couldn't be an abstract class", (Object[])new Object[0]);
        TypeValidators.validateNotNestedClass((TypeElement)restControllerClass, (String)"Rest controller class couldn't be a nested class", (Object[])new Object[0]);
        boolean restControllerNotContainFactoryMethod = Elements.allMethods((TypeElement)restControllerClass).stream().noneMatch(e -> e.getAnnotation(Factory.class) != null);
        boolean restControllerNotContainConstructorInjection = Elements.allConstructors((TypeElement)restControllerClass, e -> AnnotationsSupport.INJECT_ANNOTATIONS.stream().anyMatch(a -> e.getAnnotation(a) != null)).isEmpty();
        if (restControllerNotContainFactoryMethod && restControllerNotContainConstructorInjection) {
            TypeValidators.validateAccessibleDefaultConstructor((TypeElement)restControllerClass);
        }
    }

    private RestControllerClassSignature buildRestClassSignature(EnvironmentContext environmentContext, TypeElement restControllerClass) {
        ModuleElement restControllerModule = environmentContext.getCurrentModule();
        ParentUrl parentUrl = this.parentUrlBuilder.build(restControllerClass);
        return new RestControllerClassSignature(parentUrl, restControllerClass, this.restControllerMethodSignatureBuilder.build(restControllerModule, restControllerClass, parentUrl));
    }
}

