/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server;

import com.google.inject.Inject;
import com.google.inject.Module;
import io.rxmicro.annotation.processor.common.CommonDependenciesModule;
import io.rxmicro.annotation.processor.common.FormatSourceCodeDependenciesModule;
import io.rxmicro.annotation.processor.common.component.ModuleGeneratorConfigBuilder;
import io.rxmicro.annotation.processor.common.component.impl.AbstractModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.common.model.ClassStructure;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.EnvironmentCustomizerClassStructure;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.model.virtual.VirtualTypeElement;
import io.rxmicro.annotation.processor.common.util.Injects;
import io.rxmicro.annotation.processor.rest.RestCommonDependenciesModule;
import io.rxmicro.annotation.processor.rest.component.RestGenerationContextBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelFromJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelToJsonConverterBuilder;
import io.rxmicro.annotation.processor.rest.component.RestModelValidatorBuilder;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestGenerationContext;
import io.rxmicro.annotation.processor.rest.model.VirtualTypeClassStructure;
import io.rxmicro.annotation.processor.rest.server.RestServerDependenciesModule;
import io.rxmicro.annotation.processor.rest.server.component.CrossOriginResourceSharingResourceBuilder;
import io.rxmicro.annotation.processor.rest.server.component.HttpHealthCheckBuilder;
import io.rxmicro.annotation.processor.rest.server.component.ModelReaderBuilder;
import io.rxmicro.annotation.processor.rest.server.component.ModelWriterBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassSignatureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestControllerClassStructureBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestDocumentationGenerator;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerAggregatorClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.method.DELETE;
import io.rxmicro.rest.method.GET;
import io.rxmicro.rest.method.HEAD;
import io.rxmicro.rest.method.HttpMethods;
import io.rxmicro.rest.method.OPTIONS;
import io.rxmicro.rest.method.PATCH;
import io.rxmicro.rest.method.POST;
import io.rxmicro.rest.method.PUT;
import io.rxmicro.rest.model.ExchangeFormat;
import io.rxmicro.validation.DisableValidation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;

public final class RestServerModuleClassStructuresBuilder
extends AbstractModuleClassStructuresBuilder {
    @Inject
    private ModuleGeneratorConfigBuilder<RestServerModuleGeneratorConfig> restServerModuleGeneratorConfigBuilder;
    @Inject
    private RestControllerClassSignatureBuilder restControllerClassSignatureBuilder;
    @Inject
    private RestGenerationContextBuilder restGenerationContextBuilder;
    @Inject
    private RestControllerClassStructureBuilder restControllerClassStructureBuilder;
    @Inject
    private ModelReaderBuilder modelReaderBuilder;
    @Inject
    private ModelWriterBuilder modelWriterBuilder;
    @Inject
    private RestModelValidatorBuilder restModelValidatorBuilder;
    @Inject
    private RestModelToJsonConverterBuilder restModelToJsonConverterBuilder;
    @Inject
    private RestModelFromJsonConverterBuilder restModelFromJsonConverterBuilder;
    @Inject
    private CrossOriginResourceSharingResourceBuilder crossOriginResourceSharingResourceBuilder;
    @Inject
    private HttpHealthCheckBuilder httpHealthCheckBuilder;
    @Inject
    private RestDocumentationGenerator restDocumentationGenerator;

    public static RestServerModuleClassStructuresBuilder create() {
        RestServerModuleClassStructuresBuilder builder = new RestServerModuleClassStructuresBuilder();
        Injects.injectDependencies((Object)((Object)builder), (Module[])new Module[]{new FormatSourceCodeDependenciesModule(), new CommonDependenciesModule(), new RestCommonDependenciesModule(), new RestServerDependenciesModule()});
        return builder;
    }

    private RestServerModuleClassStructuresBuilder() {
    }

    public Set<String> getSupportedAnnotationTypes() {
        return Stream.concat(HttpMethods.HTTP_METHOD_ANNOTATIONS.stream().map(Class::getName), Stream.of(GET.List.class, POST.List.class, PUT.List.class, DELETE.List.class, PATCH.List.class, OPTIONS.List.class, HEAD.List.class).map(cl -> cl.getName().replace("$", "."))).collect(Collectors.toSet());
    }

    public Set<? extends ClassStructure> buildClassStructures(EnvironmentContext environmentContext, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Set<RestControllerClassSignature> classSignatures = this.restControllerClassSignatureBuilder.build(environmentContext, annotations, roundEnv);
            if (!classSignatures.isEmpty()) {
                environmentContext.put(this.restServerModuleGeneratorConfigBuilder.build(environmentContext));
                this.logFoundRestControllers(classSignatures);
                RestGenerationContext restGenerationContext = this.restGenerationContextBuilder.build(environmentContext, RestServerModuleGeneratorConfig.class, classSignatures);
                RestControllerClassStructureStorage restControllerClassStructureStorage = this.buildRestClassStructureStorage(environmentContext, restGenerationContext);
                HashSet<ClassStructure> classStructures = new HashSet<ClassStructure>(restControllerClassStructureStorage.getAll());
                Set<RestControllerClassStructure> restControllerClassStructures = this.restControllerClassStructureBuilder.build(environmentContext, restControllerClassStructureStorage, classSignatures);
                classStructures.addAll(restControllerClassStructures);
                classStructures.add(new RestControllerAggregatorClassStructure(environmentContext, restControllerClassStructures, this.crossOriginResourceSharingResourceBuilder.build(restControllerClassStructures, restGenerationContext), this.httpHealthCheckBuilder.build(environmentContext, restControllerClassStructures)));
                classStructures.add((ClassStructure)new EnvironmentCustomizerClassStructure(environmentContext));
                if (!((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).getDocumentationTypes().isEmpty()) {
                    this.restDocumentationGenerator.generate(environmentContext, restControllerClassStructureStorage, restControllerClassStructures);
                }
                this.addAllVirtualRequestClassStructures(classStructures, classSignatures, restControllerClassStructureStorage);
                return classStructures;
            }
            return Set.of();
        }
        catch (InterruptProcessingException e) {
            this.error(e);
            return Set.of();
        }
    }

    private void logFoundRestControllers(Set<RestControllerClassSignature> set) {
        this.info("Found the following REST controllers:\n?", new Supplier[]{() -> set.stream().map(s -> s.getMethodSignatures().stream().flatMap(m -> m.getHttpMethodMappings().stream().map(h -> Map.entry(h, m))).map(e -> Formats.format((String)"  ? ? -> ?", (Object[])new Object[]{((HttpMethodMapping)e.getKey()).getMethod(), ((HttpMethodMapping)e.getKey()).getExactOrTemplateUri(), e.getValue()})).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n"))});
    }

    private RestControllerClassStructureStorage buildRestClassStructureStorage(EnvironmentContext environmentContext, RestGenerationContext generationContext) {
        ExchangeFormat exchangeFormat = ((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).getExchangeFormatModule().getExchangeFormat();
        RestControllerClassStructureStorage.Builder builder = new RestControllerClassStructureStorage.Builder().addModelReaders(this.modelReaderBuilder.build(generationContext.getFromHttpDataModelClasses(), exchangeFormat)).addModelWriters(this.modelWriterBuilder.build(generationContext.getToHttpDataModelClasses(), exchangeFormat)).addModelFromJsonConverters(this.restModelFromJsonConverterBuilder.buildFromJson(generationContext.getFromHttpDataModelClasses(), exchangeFormat, false)).addModelToJsonConverters(this.restModelToJsonConverterBuilder.buildToJson(generationContext.getToHttpDataModelClasses(), exchangeFormat, false));
        this.addValidators(environmentContext, generationContext, builder);
        return builder.build();
    }

    private void addValidators(EnvironmentContext environmentContext, RestGenerationContext generationContext, RestControllerClassStructureStorage.Builder builder) {
        if (((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).isGenerateRequestValidators()) {
            builder.addRequestValidators(this.restModelValidatorBuilder.build(generationContext.getFromHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
        if (((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).isGenerateResponseValidators()) {
            builder.addResponseValidators(this.restModelValidatorBuilder.build(generationContext.getToHttpDataModelClasses().stream().map(MappedRestObjectModelClass::getModelClass).filter(m -> this.isAnnotationPerPackageHierarchyAbsent(m.getModelTypeElement(), DisableValidation.class)).collect(Collectors.toList())));
        }
    }

    private void addAllVirtualRequestClassStructures(Set<ClassStructure> classStructures, Set<RestControllerClassSignature> classSignatures, RestControllerClassStructureStorage restControllerClassStructureStorage) {
        for (RestControllerClassSignature classSignature : classSignatures) {
            for (RestControllerMethodSignature methodSignature : classSignature.getMethodSignatures()) {
                methodSignature.getRequestModel().getRequestType().filter(t -> t instanceof VirtualTypeElement).flatMap(t -> restControllerClassStructureStorage.getModelReaderClassStructure(t.getQualifiedName().toString())).ifPresent(mr -> classStructures.add((ClassStructure)new VirtualTypeClassStructure(mr.getModelClass(), false)));
            }
        }
    }
}

