/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestMethodSignature;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.common.util.Formats;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class RestControllerMethodSignature
implements RestMethodSignature {
    private final ParentUrl parentUrl;
    private final ExecutableElement executableElement;
    private final String simpleName;
    private final RestRequestModel requestModel;
    private final RestResponseModel responseModel;
    private final List<HttpMethodMapping> httpMethodMappings;

    public RestControllerMethodSignature(ParentUrl parentUrl, ExecutableElement executableElement, RestRequestModel requestModel, RestResponseModel responseModel, List<HttpMethodMapping> httpMethodMappings) {
        this.parentUrl = parentUrl;
        this.executableElement = executableElement;
        this.simpleName = executableElement.getSimpleName().toString();
        this.requestModel = requestModel;
        this.responseModel = responseModel;
        this.httpMethodMappings = httpMethodMappings;
    }

    public ParentUrl getParentUrl() {
        return this.parentUrl;
    }

    public ExecutableElement getExecutableElement() {
        return this.executableElement;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public RestRequestModel getRequestModel() {
        return this.requestModel;
    }

    public RestResponseModel getResponseModel() {
        return this.responseModel;
    }

    public List<HttpMethodMapping> getHttpMethodMappings() {
        return this.httpMethodMappings;
    }

    public Optional<TypeElement> getFromHttpDataType() {
        return this.requestModel.getRequestType();
    }

    public Optional<TypeElement> getToHttpDataType() {
        return this.responseModel.getResultType();
    }

    public String toString() {
        return Formats.format((String)"?.?", (Object[])new Object[]{this.executableElement.getEnclosingElement().asType(), Formats.format((String)"?(?)", (Object[])new Object[]{this.simpleName, this.executableElement.getParameters().stream().map(p -> p.asType().toString()).collect(Collectors.joining(", "))})});
    }
}

