/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.method.MethodBody;
import io.rxmicro.annotation.processor.common.model.method.MethodName;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.RestRequestModel;
import io.rxmicro.annotation.processor.rest.model.RestResponseModel;
import io.rxmicro.common.util.Formats;
import io.rxmicro.rest.server.NotFoundMessage;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public final class RestControllerMethod {
    private final List<HttpMethodMapping> httpMethodMappings;
    private final ExecutableElement method;
    private final MethodName methodName;
    private final RestRequestModel requestModel;
    private final MethodBody body;
    private final RestResponseModel responseModel;
    private final int successStatusCode;
    private final boolean notFoundPossible;

    public RestControllerMethod(List<HttpMethodMapping> httpMethodMappings, ExecutableElement method, MethodName methodName, RestRequestModel requestModel, MethodBody body, RestResponseModel responseModel, int successStatusCode, boolean notFoundPossible) {
        this.httpMethodMappings = httpMethodMappings;
        this.method = method;
        this.methodName = methodName;
        this.requestModel = requestModel;
        this.body = body;
        this.responseModel = responseModel;
        this.successStatusCode = successStatusCode;
        this.notFoundPossible = notFoundPossible;
    }

    public ExecutableElement getMethod() {
        return this.method;
    }

    public Optional<TypeElement> getFromHttpDataType() {
        return this.requestModel.getRequestType();
    }

    public Optional<TypeElement> getToHttpDataType() {
        return this.responseModel.getResultType();
    }

    public List<HttpMethodMapping> getHttpMethodMappings() {
        return this.httpMethodMappings;
    }

    public MethodName getName() {
        return this.methodName;
    }

    public MethodBody getBody() {
        return this.body;
    }

    public int getSuccessStatusCode() {
        return this.successStatusCode;
    }

    boolean isNotFoundPossible() {
        return this.notFoundPossible;
    }

    String getNotFoundMessage() {
        return Optional.ofNullable(this.method.getAnnotation(NotFoundMessage.class)).map(NotFoundMessage::value).orElse("Not Found");
    }

    boolean isVoidReturn() {
        return this.responseModel.isVoidReturn() || this.responseModel.isReactiveVoid();
    }

    public String toString() {
        return Formats.format((String)"?.?(?)", (Object[])new Object[]{this.method.getEnclosingElement().asType().toString(), this.method.getSimpleName(), this.method.getParameters().stream().map(v -> v.asType().toString()).collect(Collectors.joining(", "))});
    }
}

