/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.model;

import io.rxmicro.annotation.processor.common.model.TypeSignature;
import io.rxmicro.annotation.processor.rest.model.ParentUrl;
import io.rxmicro.annotation.processor.rest.model.RestClassSignature;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethodSignature;
import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;

public final class RestControllerClassSignature
extends TypeSignature
implements RestClassSignature {
    private final ParentUrl parentUrl;
    private final TypeElement typeElement;
    private final List<RestControllerMethodSignature> methodSignatures;

    public RestControllerClassSignature(ParentUrl parentUrl, TypeElement typeElement, List<RestControllerMethodSignature> methodSignatures) {
        this.parentUrl = (ParentUrl)Requires.require((Object)parentUrl);
        this.typeElement = (TypeElement)Requires.require((Object)typeElement);
        this.methodSignatures = ExCollections.unmodifiableList(methodSignatures);
    }

    public ParentUrl getParentUrl() {
        return this.parentUrl;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public Set<TypeElement> getFromHttpDataModelTypes() {
        return this.methodSignatures.stream().flatMap(m -> m.getRequestModel().getRequestType().stream()).collect(Collectors.toSet());
    }

    public Set<TypeElement> getToHttpDataModelTypes() {
        return this.methodSignatures.stream().flatMap(m -> m.getResponseModel().getResultType().stream()).collect(Collectors.toSet());
    }

    public List<RestControllerMethodSignature> getMethodSignatures() {
        return this.methodSignatures;
    }

    protected String getTypeFullName() {
        return this.typeElement.getQualifiedName().toString();
    }
}

