/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.DocumentationGenerator;
import io.rxmicro.annotation.processor.common.component.impl.AbstractProcessorComponent;
import io.rxmicro.annotation.processor.common.model.DocumentStructure;
import io.rxmicro.annotation.processor.common.model.DocumentationType;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.util.ServiceLoaderImplementations;
import io.rxmicro.annotation.processor.rest.server.component.AbstractDocumentationModuleClassStructuresBuilder;
import io.rxmicro.annotation.processor.rest.server.component.RestDocumentationGenerator;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestServerModuleGeneratorConfig;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;

@Singleton
public final class RestDocumentationGeneratorImpl
extends AbstractProcessorComponent
implements RestDocumentationGenerator {
    @Inject
    private DocumentationGenerator documentationGenerator;

    @Override
    public void generate(EnvironmentContext environmentContext, RestControllerClassStructureStorage restControllerClassStructureStorage, Set<RestControllerClassStructure> restControllerClassStructures) {
        List documentationBuilders = ServiceLoaderImplementations.getImplementations(AbstractDocumentationModuleClassStructuresBuilder.class, service -> ServiceLoader.load(service, RestDocumentationGeneratorImpl.class.getClassLoader()));
        HashSet<DocumentationType> toProcess = new HashSet<DocumentationType>(((RestServerModuleGeneratorConfig)environmentContext.get(RestServerModuleGeneratorConfig.class)).getDocumentationTypes());
        HashSet<? extends DocumentStructure> result = new HashSet<DocumentStructure>();
        for (AbstractDocumentationModuleClassStructuresBuilder documentationBuilder : documentationBuilders) {
            if (!toProcess.remove(documentationBuilder.getDocumentationType())) continue;
            result.addAll(documentationBuilder.build(environmentContext, restControllerClassStructureStorage, restControllerClassStructures));
        }
        if (!toProcess.isEmpty()) {
            throw new InternalErrorException("Documentation generator not found: ?", new Object[]{toProcess});
        }
        result.forEach(arg_0 -> ((DocumentationGenerator)this.documentationGenerator).generate(arg_0));
    }
}

