/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.EnvironmentContext;
import io.rxmicro.annotation.processor.rest.server.component.HttpHealthCheckBuilder;
import io.rxmicro.annotation.processor.rest.server.model.HttpHealthCheck;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.common.util.UrlPaths;
import io.rxmicro.monitoring.healthcheck.EnableHttpHealthCheck;
import java.util.Set;
import java.util.TreeSet;

@Singleton
public final class HttpHealthCheckBuilderImpl
implements HttpHealthCheckBuilder {
    @Override
    public Set<HttpHealthCheck> build(EnvironmentContext environmentContext, Set<RestControllerClassStructure> restControllerClassStructures) {
        TreeSet<HttpHealthCheck> set = new TreeSet<HttpHealthCheck>();
        EnableHttpHealthCheck enableHttpHealthCheckOnModule = environmentContext.getCurrentModule().getAnnotation(EnableHttpHealthCheck.class);
        if (enableHttpHealthCheckOnModule != null) {
            set.add(new HttpHealthCheck(enableHttpHealthCheckOnModule.method(), UrlPaths.normalizeUrlPath((String)enableHttpHealthCheckOnModule.endpoint())));
        }
        for (RestControllerClassStructure restControllerClassStructure : restControllerClassStructures) {
            EnableHttpHealthCheck enableHttpHealthCheck = restControllerClassStructure.getOwnerClass().getAnnotation(EnableHttpHealthCheck.class);
            if (enableHttpHealthCheck == null) continue;
            set.add(new HttpHealthCheck(enableHttpHealthCheck.method(), restControllerClassStructure.getParentUrl().getFullUrlPath(enableHttpHealthCheck.endpoint())));
        }
        return set;
    }
}

