/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.rest.server.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.rest.model.HttpMethodMapping;
import io.rxmicro.annotation.processor.rest.model.MappedRestObjectModelClass;
import io.rxmicro.annotation.processor.rest.model.RestGenerationContext;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.component.CrossOriginResourceSharingResourceBuilder;
import io.rxmicro.annotation.processor.rest.server.model.CrossOriginResourceSharingResourceProxy;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.rest.model.UrlSegments;
import io.rxmicro.rest.server.detail.model.CrossOriginResourceSharingResource;
import io.rxmicro.rest.server.feature.EnableCrossOriginResourceSharing;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Singleton
public final class CrossOriginResourceSharingResourceBuilderImpl
implements CrossOriginResourceSharingResourceBuilder {
    @Override
    public Set<CrossOriginResourceSharingResource> build(Collection<RestControllerClassStructure> classStructures, RestGenerationContext context) {
        LinkedHashMap<String, CrossOriginResourceSharingResourceProxy.Builder> exactUrlMap = new LinkedHashMap<String, CrossOriginResourceSharingResourceProxy.Builder>();
        LinkedHashMap<UrlSegments, CrossOriginResourceSharingResourceProxy.Builder> urlTemplateMap = new LinkedHashMap<UrlSegments, CrossOriginResourceSharingResourceProxy.Builder>();
        Map<String, RestObjectModelClass> fromHttpDataModelMap = null;
        for (RestControllerClassStructure classStructure : classStructures) {
            EnableCrossOriginResourceSharing enableCORS = classStructure.getOwnerClass().getAnnotation(EnableCrossOriginResourceSharing.class);
            if (enableCORS == null || enableCORS.allowOrigins().length <= 0) continue;
            if (fromHttpDataModelMap == null) {
                fromHttpDataModelMap = this.buildHttpDataModelMap(context.getFromHttpDataModelClasses());
            }
            this.addCORSResources(exactUrlMap, urlTemplateMap, classStructure, enableCORS, fromHttpDataModelMap);
        }
        if (exactUrlMap.isEmpty() && urlTemplateMap.isEmpty()) {
            return Set.of();
        }
        return Stream.concat(exactUrlMap.entrySet().stream().map(e -> ((CrossOriginResourceSharingResourceProxy.Builder)e.getValue()).build((String)e.getKey())), urlTemplateMap.entrySet().stream().map(e -> ((CrossOriginResourceSharingResourceProxy.Builder)e.getValue()).build((UrlSegments)e.getKey()))).collect(Collectors.toSet());
    }

    private Map<String, RestObjectModelClass> buildHttpDataModelMap(List<MappedRestObjectModelClass> httpDataModelClasses) {
        return httpDataModelClasses.stream().map(MappedRestObjectModelClass::getModelClass).collect(Collectors.toMap(c -> c.getModelTypeMirror().toString(), Function.identity(), (o1, o2) -> o1));
    }

    private void addCORSResources(Map<String, CrossOriginResourceSharingResourceProxy.Builder> exactUrlMap, Map<UrlSegments, CrossOriginResourceSharingResourceProxy.Builder> urlTemplateMap, RestControllerClassStructure classStructure, EnableCrossOriginResourceSharing enableCORS, Map<String, RestObjectModelClass> fromHttpDataModelMap) {
        for (RestControllerMethod method : classStructure.getMethods()) {
            for (HttpMethodMapping httpMethodMapping : method.getHttpMethodMappings()) {
                CrossOriginResourceSharingResourceProxy.Builder builder = this.newBuilder(exactUrlMap, urlTemplateMap, enableCORS, httpMethodMapping);
                builder.addMethod(httpMethodMapping.getMethod());
                method.getFromHttpDataType().ifPresent(t -> ((RestObjectModelClass)fromHttpDataModelMap.get(t.getQualifiedName().toString())).getHeaderEntries().stream().map(e -> ((RestModelField)e.getKey()).getModelName()).forEach(builder::addHeader));
            }
        }
    }

    private CrossOriginResourceSharingResourceProxy.Builder newBuilder(Map<String, CrossOriginResourceSharingResourceProxy.Builder> exactUrlMap, Map<UrlSegments, CrossOriginResourceSharingResourceProxy.Builder> urlTemplateMap, EnableCrossOriginResourceSharing enableCORS, HttpMethodMapping httpMethodMapping) {
        return httpMethodMapping.isUrlSegmentsPresent() ? urlTemplateMap.computeIfAbsent(httpMethodMapping.getUrlSegments(), u -> new CrossOriginResourceSharingResourceProxy.Builder(enableCORS)) : exactUrlMap.computeIfAbsent(httpMethodMapping.getUri(), u -> new CrossOriginResourceSharingResourceProxy.Builder(enableCORS));
    }
}

