/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.model;

import io.rxmicro.annotation.processor.documentation.model.StandardHttpError;
import io.rxmicro.common.util.Formats;
import io.rxmicro.http.HttpStatuses;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class StandardHttpErrorStorage {
    private final Map<Integer, StandardHttpError> storage = List.of(new StandardHttpError.Builder().setStatus(307).setDescription("The request should be repeated with another URI, however, future requests should still use the original URI.").setExampleErrorMessage("Temporary Redirect").build(), new StandardHttpError.Builder().setStatus(308).setDescription("The request and all future requests should be repeated using another URI.").setExampleErrorMessage("Permanent Redirect").build(), new StandardHttpError.Builder().setStatus(400).setDescription("If current request contains validation error.").setMessageDescription("The detailed cause of the arisen validation error.").setExampleErrorMessage("Invalid Request").build(), new StandardHttpError.Builder().setStatus(500).setDescription("If internal server error detected.").setMessageDescription(Formats.format((String)"`?` value (by default) or the detailed cause of the arisen internal server error.", (Object[])new Object[]{HttpStatuses.getErrorMessage((int)500)})).setExampleErrorMessage("Internal Error").setWithShowErrorCauseReadMoreLink().build(), new StandardHttpError.Builder().setStatus(504).setDescription("If response is not received within a specified time period.").setMessageDescription(Formats.format((String)"`?` value (by default) or contains external rest micro service endpoint, which is not available now.", (Object[])new Object[]{HttpStatuses.getErrorMessage((int)504)})).setExampleErrorMessage("Request Timeout").setWithShowErrorCauseReadMoreLink().build()).stream().collect(Collectors.toMap(StandardHttpError::getStatus, Function.identity()));

    public Optional<StandardHttpError> get(int status) {
        return Optional.ofNullable(this.storage.get(status));
    }
}

