/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute;

import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.MaxSize;
import io.rxmicro.validation.constraint.MinSize;
import io.rxmicro.validation.constraint.Size;
import io.rxmicro.validation.constraint.UniqueItems;
import java.util.List;
import java.util.function.BiConsumer;

public final class JsonArrayAttributesReader {
    private static final String MIN_ITEMS = "minItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String UNIQUE_ITEMS = "uniqueItems";
    private final List<BiConsumer<ModelField, JsonObjectBuilder>> biConsumers = List.of((modelField, builder) -> {
        Size size = (Size)modelField.getAnnotation(Size.class);
        if (size != null && !size.off()) {
            builder.put(MIN_ITEMS, (Object)size.value());
            builder.put(MAX_ITEMS, (Object)size.value());
        }
    }, (modelField, builder) -> {
        MinSize minSize = (MinSize)modelField.getAnnotation(MinSize.class);
        if (minSize != null && !minSize.off()) {
            builder.put(MIN_ITEMS, (Object)minSize.value());
        }
    }, (modelField, builder) -> {
        MaxSize maxSize = (MaxSize)modelField.getAnnotation(MaxSize.class);
        if (maxSize != null && !maxSize.off()) {
            builder.put(MAX_ITEMS, (Object)maxSize.value());
        }
    }, (modelField, builder) -> {
        UniqueItems uniqueItems = (UniqueItems)modelField.getAnnotation(UniqueItems.class);
        if (uniqueItems != null && !uniqueItems.off()) {
            builder.put(UNIQUE_ITEMS, (Object)true);
        }
    });

    public void read(JsonObjectBuilder builder, ModelField modelField) {
        this.biConsumers.forEach(biConsumer -> biConsumer.accept(modelField, builder));
    }
}

