/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.ImpossibleException;
import io.rxmicro.json.JsonNumber;
import io.rxmicro.validation.base.LocationAccuracy;
import io.rxmicro.validation.constraint.Lat;
import io.rxmicro.validation.constraint.Lng;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class NumberExampleBuilder
implements TypeExampleBuilder {
    private final Map<String, Supplier<JsonNumber>> exampleByTypeMap = Map.of(Byte.class.getName(), () -> new JsonNumber("10"), Short.class.getName(), () -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"10_000")), Integer.class.getName(), () -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000")), Long.class.getName(), () -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000_000")), BigInteger.class.getName(), () -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000_000_000_000_000")), Float.class.getName(), () -> new JsonNumber("3.14"), Double.class.getName(), () -> new JsonNumber("3.1415926535"), BigDecimal.class.getName(), () -> new JsonNumber("3.1415926535897932384626433832795028841971"), JsonNumber.class.getName(), () -> new JsonNumber("3.1415926535897932384626433832795028841971"));
    private final List<JsonNumberExampleBuilder> jsonNumberExampleBuilders = List.of(restModelField -> Optional.ofNullable((Lat)restModelField.getAnnotation(Lat.class)).filter(a -> !a.off()).map(lat -> this.withLocationAccuracy("34.063821", lat.value())), restModelField -> Optional.ofNullable((Lng)restModelField.getAnnotation(Lng.class)).filter(a -> !a.off()).map(lng -> this.withLocationAccuracy("-118.296339", lng.value())), restModelField -> Optional.ofNullable((MaxDouble)restModelField.getAnnotation(MaxDouble.class)).filter(a -> !a.off()).map(maxDouble -> new JsonNumber(String.valueOf(maxDouble.value()))), restModelField -> Optional.ofNullable((MaxInt)restModelField.getAnnotation(MaxInt.class)).filter(a -> !a.off()).map(maxInt -> new JsonNumber(String.valueOf(maxInt.value()))), restModelField -> Optional.ofNullable((MaxNumber)restModelField.getAnnotation(MaxNumber.class)).filter(a -> !a.off()).map(maxNumber -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)maxNumber.value()))), restModelField -> Optional.ofNullable((MinDouble)restModelField.getAnnotation(MinDouble.class)).filter(a -> !a.off()).map(minDouble -> new JsonNumber(String.valueOf(minDouble.value()))), restModelField -> Optional.ofNullable((MinInt)restModelField.getAnnotation(MinInt.class)).filter(a -> !a.off()).map(minInt -> new JsonNumber(String.valueOf(minInt.value()))), restModelField -> Optional.ofNullable((MinNumber)restModelField.getAnnotation(MinNumber.class)).filter(a -> !a.off()).map(minNumber -> new JsonNumber(Numbers.removeUnderscoresIfPresent((String)minNumber.value()))), restModelField -> Optional.ofNullable((Numeric)restModelField.getAnnotation(Numeric.class)).filter(a -> !a.off()).map(numeric -> {
        BigDecimal bigDecimal = new BigDecimal("987654321.987654321");
        if (numeric.scale() > -1) {
            return new JsonNumber(bigDecimal.setScale(numeric.scale(), RoundingMode.HALF_UP).toPlainString());
        }
        return new JsonNumber(bigDecimal.toPlainString());
    }));

    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        return this.exampleByTypeMap.containsKey(typeMirror.toString());
    }

    public JsonNumber getExample(RestModelField restModelField, TypeMirror typeMirror) {
        return this.jsonNumberExampleBuilders.stream().flatMap(builder -> builder.build(restModelField).stream()).findFirst().orElseGet(() -> this.getExampleByType(typeMirror));
    }

    private JsonNumber withLocationAccuracy(String value, LocationAccuracy locationAccuracy) {
        return new JsonNumber(new BigDecimal(value).setScale(locationAccuracy.getCoordinateScale(), RoundingMode.HALF_UP).toPlainString());
    }

    private JsonNumber getExampleByType(TypeMirror typeMirror) {
        return Optional.ofNullable(this.exampleByTypeMap.get(typeMirror.toString())).orElseThrow(() -> new ImpossibleException("Example by number type must be found!", new Object[0])).get();
    }

    private static interface JsonNumberExampleBuilder {
        public Optional<JsonNumber> build(RestModelField var1);
    }
}

