/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.SubEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class EnumExampleBuilder
implements TypeExampleBuilder {
    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        Optional typeElementOptional = Elements.asEnumElement((TypeMirror)typeMirror);
        if (typeElementOptional.isPresent()) {
            return true;
        }
        Enumeration enumeration = (Enumeration)restModelField.getAnnotation(Enumeration.class);
        return enumeration != null && !enumeration.off();
    }

    @Override
    public String getExample(RestModelField restModelField, TypeMirror typeMirror) {
        Optional typeElementOptional = Elements.asEnumElement((TypeMirror)typeMirror);
        if (typeElementOptional.isPresent()) {
            return this.getEnumExample((ModelField)restModelField, (TypeElement)typeElementOptional.get());
        }
        Enumeration enumeration = (Enumeration)restModelField.getAnnotation(Enumeration.class);
        if (enumeration.value().length > 0) {
            return enumeration.value()[0];
        }
        throw new InterruptProcessingException(restModelField.getElementAnnotatedBy(Enumeration.class), "Missing enumeration values! Add at least one item!", new Object[0]);
    }

    private String getEnumExample(ModelField modelField, TypeElement typeElement) {
        Set enumConstants = Elements.getAllowedEnumConstants((TypeElement)typeElement);
        if (enumConstants.isEmpty()) {
            throw new InterruptProcessingException(modelField.getFieldElement(), "Missing enum constants! Add at least one constant to '?' class!", new Object[]{typeElement.getQualifiedName()});
        }
        SubEnum subEnum = (SubEnum)modelField.getAnnotation(SubEnum.class);
        if (subEnum != null && !subEnum.off()) {
            if (subEnum.include().length > 0) {
                return subEnum.include()[0];
            }
            HashSet<String> excludes = new HashSet<String>(Arrays.asList(subEnum.exclude()));
            return enumConstants.stream().filter(c -> !excludes.contains(c)).findFirst().orElseThrow(() -> {
                throw new InterruptProcessingException(modelField.getElementAnnotatedBy(SubEnum.class), "All enum constants are excluded!", new Object[0]);
            });
        }
        return (String)enumConstants.iterator().next();
    }
}

