/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Types;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.validation.constraint.Future;
import io.rxmicro.validation.constraint.FutureOrPresent;
import io.rxmicro.validation.constraint.Past;
import io.rxmicro.validation.constraint.PastOrPresent;
import io.rxmicro.validation.constraint.TruncatedTime;
import java.time.Instant;
import java.time.ZoneOffset;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class DateTimeExampleBuilder
implements TypeExampleBuilder {
    private static final int TRUNCATED_MILLISECONDS = 1000;
    private static final int TRUNCATED_SECONDS = 60000;
    private static final int TRUNCATED_MINUTES = 3600000;
    private static final int TRUNCATED_HOURS = 86400000;
    private static final String NOT_IMPL_YET = "Not impl yet";
    private static final int YEARS_TO_ADD_IN_FUTURE = 200;

    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        return Types.SUPPORTED_DATE_TIME_CLASSES.contains(typeMirror.toString());
    }

    @Override
    public String getExample(RestModelField restModelField, TypeMirror typeMirror) {
        Future future = (Future)restModelField.getAnnotation(Future.class);
        FutureOrPresent futureOrPresent = (FutureOrPresent)restModelField.getAnnotation(FutureOrPresent.class);
        if (future != null && !future.off() || futureOrPresent != null && !futureOrPresent.off()) {
            return this.getFuture(restModelField.getFieldClass());
        }
        Past past = (Past)restModelField.getAnnotation(Past.class);
        PastOrPresent pastOrPresent = (PastOrPresent)restModelField.getAnnotation(PastOrPresent.class);
        if (past != null && !past.off() || pastOrPresent != null && !pastOrPresent.off()) {
            return this.getPast(restModelField.getFieldClass());
        }
        TruncatedTime truncatedTime = (TruncatedTime)restModelField.getAnnotation(TruncatedTime.class);
        if (truncatedTime != null && !truncatedTime.off()) {
            return this.getTruncatedTime(restModelField.getFieldClass(), truncatedTime);
        }
        return this.getDefaultDateTime(restModelField.getFieldClass());
    }

    private String getTruncatedTime(TypeMirror typeMirror, TruncatedTime truncatedTime) {
        if (typeMirror.toString().equals(Instant.class.getName())) {
            long epochMilli = Instant.parse("1987-04-10T23:40:15.789Z").toEpochMilli();
            epochMilli = truncatedTime.value() == TruncatedTime.Truncated.MILLIS ? epochMilli / 1000L * 1000L : (truncatedTime.value() == TruncatedTime.Truncated.SECONDS ? epochMilli / 60000L * 60000L : (truncatedTime.value() == TruncatedTime.Truncated.MINUTES ? epochMilli / 3600000L * 3600000L : epochMilli / 86400000L * 86400000L));
            return Instant.ofEpochMilli(epochMilli).toString();
        }
        throw new UnsupportedOperationException(NOT_IMPL_YET);
    }

    private String getFuture(TypeMirror typeMirror) {
        if (typeMirror.toString().equals(Instant.class.getName())) {
            return Instant.parse("1987-04-10T23:40:15.789Z").atOffset(ZoneOffset.UTC).plusYears(200L).toInstant().toString();
        }
        throw new UnsupportedOperationException(NOT_IMPL_YET);
    }

    private String getPast(TypeMirror typeMirror) {
        if (typeMirror.toString().equals(Instant.class.getName())) {
            return "1987-04-10T23:40:15.789Z";
        }
        throw new UnsupportedOperationException(NOT_IMPL_YET);
    }

    private String getDefaultDateTime(TypeMirror typeMirror) {
        if (typeMirror.toString().equals(Instant.class.getName())) {
            return "1987-04-10T23:40:15.789Z";
        }
        throw new UnsupportedOperationException(NOT_IMPL_YET);
    }
}

