/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.type.IterableModelClass;
import io.rxmicro.annotation.processor.common.model.type.ModelClass;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonStructureExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.json.JsonHelper;
import io.rxmicro.json.JsonObjectBuilder;
import java.util.List;
import java.util.Map;

@Singleton
public final class JsonStructureExampleBuilderImpl
implements JsonStructureExampleBuilder {
    @Inject
    private ExampleValueBuilder exampleValueBuilder;

    @Override
    public String build(RestObjectModelClass restObjectModelClass) {
        return JsonHelper.toJsonString(this.buildJsonObject(restObjectModelClass), (boolean)true);
    }

    private Map<String, Object> buildJsonObject(RestObjectModelClass restObjectModelClass) {
        JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
        restObjectModelClass.getAllDeclaredParametersStream().forEach(entry -> {
            if (((ModelClass)entry.getValue()).isObject()) {
                jsonObjectBuilder.put(((RestModelField)entry.getKey()).getModelName(), this.buildJsonObject((RestObjectModelClass)((ModelClass)entry.getValue()).asObject()));
            } else if (((ModelClass)entry.getValue()).isIterable()) {
                jsonObjectBuilder.put(((RestModelField)entry.getKey()).getModelName(), this.buildJsonArray((RestModelField)entry.getKey(), ((ModelClass)entry.getValue()).asIterable()));
            } else {
                jsonObjectBuilder.put(((RestModelField)entry.getKey()).getModelName(), this.exampleValueBuilder.getExample((RestModelField)entry.getKey()));
            }
        });
        return jsonObjectBuilder.build();
    }

    private List<Object> buildJsonArray(RestModelField restModelField, IterableModelClass iterableModelClass) {
        if (iterableModelClass.isObjectIterable()) {
            return List.of(this.buildJsonObject((RestObjectModelClass)iterableModelClass.getElementModelClass().asObject()));
        }
        if (iterableModelClass.isPrimitiveIterable() || iterableModelClass.isEnumIterable()) {
            return this.exampleValueBuilder.getExamples(restModelField);
        }
        throw new InternalErrorException("Unsupported array item class type: ?", new Object[]{iterableModelClass.getElementModelClass().getClass()});
    }
}

