/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.model.type.EnumModelClass;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.component.JsonAttributesReader;
import io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute.JsonArrayAttributesReader;
import io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute.JsonNumberAttributesReader;
import io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute.JsonStringAttributesReader;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.SubEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class JsonAttributesReaderImpl
implements JsonAttributesReader {
    private static final String FORMAT = "format";
    private static final String ENUM = "enum";
    private static final String DATE_TIME = "date-time";
    private final JsonStringAttributesReader jsonStringAttributesReader = new JsonStringAttributesReader();
    private final JsonNumberAttributesReader jsonNumberAttributesReader = new JsonNumberAttributesReader();
    private final JsonArrayAttributesReader jsonArrayAttributesReader = new JsonArrayAttributesReader();

    @Override
    public void readStringPrimitiveAttributes(JsonObjectBuilder builder, ModelField modelField) {
        this.jsonStringAttributesReader.read(builder, modelField);
    }

    @Override
    public void readDateTimePrimitiveAttributes(JsonObjectBuilder builder, ModelField modelField) {
        builder.put(FORMAT, (Object)DATE_TIME);
    }

    @Override
    public void readNumberPrimitiveAttributes(JsonObjectBuilder builder, ModelField modelField) {
        Optional.ofNullable((String)Numbers.NUMBER_FORMATS.get(modelField.getFieldClass().toString())).ifPresent(t -> builder.put(FORMAT, t));
        this.jsonNumberAttributesReader.read(builder, modelField);
    }

    @Override
    public void readEnumAttributes(JsonObjectBuilder builder, ModelField modelField, EnumModelClass enumModelClass) {
        Set enumConstants = Elements.getAllowedEnumConstants((TypeMirror)enumModelClass.getTypeMirror());
        SubEnum subEnum = (SubEnum)modelField.getAnnotation(SubEnum.class);
        if (subEnum != null && !subEnum.off()) {
            if (subEnum.include().length > 0) {
                builder.put(ENUM, Arrays.asList(subEnum.include()));
            } else {
                LinkedHashSet enums = new LinkedHashSet(enumConstants);
                enums.removeAll(Arrays.asList(subEnum.exclude()));
                builder.put(ENUM, new ArrayList(enums));
            }
        } else {
            builder.put(ENUM, new ArrayList(enumConstants));
        }
    }

    @Override
    public void readArrayAttributes(JsonObjectBuilder builder, ModelField modelField) {
        this.jsonArrayAttributesReader.read(builder, modelField);
    }
}

