/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.PathVariablesResolver;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.ExternalResourceReader;
import io.rxmicro.annotation.processor.documentation.component.IncludeReferenceSyntaxProvider;
import io.rxmicro.annotation.processor.documentation.component.impl.BaseDocumentationReader;
import io.rxmicro.annotation.processor.documentation.model.provider.DescriptionAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.IncludeDescriptionAnnotationValueProvider;
import io.rxmicro.annotation.processor.documentation.model.provider.SimpleErrorResponseDescriptionAnnotationValueProvider;
import io.rxmicro.documentation.Description;
import io.rxmicro.documentation.IncludeDescription;
import io.rxmicro.documentation.IncludeMode;
import io.rxmicro.documentation.SimpleErrorResponse;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;

@Singleton
public final class DescriptionReaderImpl
extends BaseDocumentationReader
implements DescriptionReader {
    @Inject
    private PathVariablesResolver pathVariablesResolver;
    @Inject
    private ExternalResourceReader externalResourceReader;
    @Inject
    private IncludeReferenceSyntaxProvider includeReferenceSyntaxProvider;

    @Override
    public Optional<String> readDescription(Element element, String projectDirectory) {
        Description description = element.getAnnotation(Description.class);
        IncludeDescription includeDescription = element.getAnnotation(IncludeDescription.class);
        this.validate(element, description, includeDescription);
        if (description != null) {
            DescriptionAnnotationValueProvider provider = new DescriptionAnnotationValueProvider(description);
            return Optional.of(this.resolveString(element, provider, false));
        }
        if (includeDescription != null) {
            IncludeDescriptionAnnotationValueProvider provider = new IncludeDescriptionAnnotationValueProvider(includeDescription);
            return Optional.of(this.readIncludedDescription(element, projectDirectory, this.resolveString(element, provider, true), includeDescription.includeMode()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> readDescription(Element element, String projectDirectory, SimpleErrorResponse simpleErrorResponse) {
        String description = simpleErrorResponse.description();
        IncludeDescription includeDescription = simpleErrorResponse.includeDescription();
        this.validate(element, description, includeDescription);
        if (!description.isEmpty()) {
            SimpleErrorResponseDescriptionAnnotationValueProvider provider = new SimpleErrorResponseDescriptionAnnotationValueProvider(simpleErrorResponse);
            return Optional.of(this.resolveString(element, provider, false));
        }
        if (!includeDescription.resource().isEmpty()) {
            IncludeDescriptionAnnotationValueProvider provider = new IncludeDescriptionAnnotationValueProvider(includeDescription);
            return Optional.of(this.readIncludedDescription(element, projectDirectory, this.resolveString(element, provider, true), includeDescription.includeMode()));
        }
        return Optional.empty();
    }

    private void validate(Element element, Description description, IncludeDescription includeDescription) {
        if (description != null && includeDescription != null) {
            throw new InterruptProcessingException(element, "Only one annotation from ? list can be applied to this element", new Object[]{List.of(Description.class.getName(), IncludeDescription.class.getName())});
        }
    }

    private void validate(Element element, String description, IncludeDescription includeDescription) {
        if (!description.isEmpty() && !includeDescription.resource().isEmpty()) {
            throw new InterruptProcessingException(element, "Both 'description' and 'includeDescription' couldn't be specified for the error response", new Object[0]);
        }
    }

    private String readIncludedDescription(Element element, String projectDirectory, String resource, IncludeMode includeMode) {
        String resourcePath = this.pathVariablesResolver.resolvePathVariables(element, projectDirectory, resource);
        if (includeMode == IncludeMode.INCLUDE_REFERENCE) {
            return this.includeReferenceSyntaxProvider.include(resourcePath);
        }
        return this.externalResourceReader.read(element, resourcePath);
    }
}

