/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.validators.VariableDefinitionValidators;
import io.rxmicro.annotation.processor.documentation.model.AnnotationValueProvider;
import java.util.List;
import javax.lang.model.element.Element;

public class BaseDocumentationReader {
    public final String resolveString(Element owner, AnnotationValueProvider annotationValueProvider, boolean expectOtherVariableProcessor) {
        VariableDefinitionValidators.validateThatVariablesContainEvenItemCount((Element)owner, annotationValueProvider.getAnnotationClass(), (String)"variables", (String[])annotationValueProvider.getVariables());
        List<String> variables = List.of(annotationValueProvider.getVariables());
        String result = annotationValueProvider.getValue();
        for (int i = 0; i < variables.size(); i += 2) {
            String variableName = variables.get(i);
            VariableDefinitionValidators.validateVariableNameFormat((Element)owner, annotationValueProvider.getAnnotationClass(), (String)"variables", (String)variableName);
            this.validateThatRedundantVariableNotDefined(owner, annotationValueProvider, variableName);
            String variableValue = variables.get(i + 1);
            result = result.replace(variableName, variableValue);
        }
        if (!expectOtherVariableProcessor) {
            this.throwErrorIfUnresolvedVariablesExist(owner, annotationValueProvider, result);
        }
        return result;
    }

    private void validateThatRedundantVariableNotDefined(Element element, AnnotationValueProvider annotationValueProvider, String variableName) {
        boolean found = false;
        for (String value : annotationValueProvider.getAllValues()) {
            if (!value.contains(variableName)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InterruptProcessingException(element, "'@?.variables()' parameter contains redundant variable: '?'! Remove this variable definition!", new Object[]{annotationValueProvider.getAnnotationClass().getSimpleName(), variableName});
        }
    }

    private void throwErrorIfUnresolvedVariablesExist(Element element, AnnotationValueProvider annotationValueProvider, String result) {
        int startIndex = result.indexOf("${");
        if (startIndex != -1) {
            int endIndex = result.indexOf(125, startIndex + 1);
            throw new InterruptProcessingException(element, "'@?.?()' contains undefined variable: '?'! Add variable definition using '@?.variables()' parameter!", new Object[]{annotationValueProvider.getAnnotationClass().getSimpleName(), annotationValueProvider.getAnnotationValueParameterName(), result.substring(startIndex, endIndex == -1 ? result.length() : endIndex + 1), annotationValueProvider.getAnnotationClass().getSimpleName()});
        }
    }
}

