/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.model;

import io.rxmicro.common.util.Requires;
import io.rxmicro.http.HttpStatuses;

public final class StandardHttpError {
    private final int status;
    private final String description;
    private final String exampleErrorMessage;
    private final String messageDescription;
    private final boolean withShowErrorCauseReadMoreLink;

    private StandardHttpError(int status, String description, String exampleErrorMessage, String messageDescription, boolean withShowErrorCauseReadMoreLink) {
        this.status = status;
        this.description = (String)Requires.require((Object)description);
        this.exampleErrorMessage = exampleErrorMessage;
        this.messageDescription = messageDescription;
        this.withShowErrorCauseReadMoreLink = withShowErrorCauseReadMoreLink;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExampleErrorMessage() {
        return this.exampleErrorMessage;
    }

    public String getMessageDescription() {
        return this.messageDescription;
    }

    public boolean isWithShowErrorCauseReadMoreLink() {
        return this.withShowErrorCauseReadMoreLink;
    }

    public static final class Builder {
        private int status;
        private String description;
        private String exampleErrorMessage;
        private String messageDescription;
        private boolean withShowErrorCauseReadMoreLink;

        public Builder setStatus(int status) {
            this.status = status;
            this.exampleErrorMessage = HttpStatuses.getErrorMessage((int)status);
            return this;
        }

        public Builder setDescription(String description) {
            this.description = (String)Requires.require((Object)description);
            return this;
        }

        public Builder setExampleErrorMessage(String exampleErrorMessage) {
            this.exampleErrorMessage = (String)Requires.require((Object)exampleErrorMessage);
            return this;
        }

        public Builder setMessageDescription(String messageDescription) {
            this.messageDescription = (String)Requires.require((Object)messageDescription);
            return this;
        }

        public Builder setWithShowErrorCauseReadMoreLink() {
            this.withShowErrorCauseReadMoreLink = true;
            return this;
        }

        public StandardHttpError build() {
            return new StandardHttpError(this.status, this.description, this.exampleErrorMessage, this.messageDescription, this.withShowErrorCauseReadMoreLink);
        }
    }
}

