/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute;

import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.DomainName;
import io.rxmicro.validation.constraint.Email;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.HostName;
import io.rxmicro.validation.constraint.IP;
import io.rxmicro.validation.constraint.Length;
import io.rxmicro.validation.constraint.MaxLength;
import io.rxmicro.validation.constraint.MinLength;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.Phone;
import io.rxmicro.validation.constraint.Skype;
import io.rxmicro.validation.constraint.Telegram;
import io.rxmicro.validation.constraint.URI;
import io.rxmicro.validation.constraint.URLEncoded;
import io.rxmicro.validation.constraint.Viber;
import io.rxmicro.validation.constraint.WhatsApp;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class JsonStringAttributesReader {
    private static final String FORMAT = "format";
    private static final String PATTERN = "pattern";
    private static final String MIN_LENGTH = "minLength";
    private static final String MAX_LENGTH = "maxLength";
    private static final String ENUM = "enum";
    private static final String EMAIL = "email";
    private static final String PHONE = "phone";
    private static final String TELEGRAM = "telegram";
    private static final String VIBER = "viber";
    private static final String WHATSAPP = "whatsapp";
    private static final String SKYPE = "skype";
    private static final String URI = "uri";
    private static final String URL_ENCODED = "url-encoded";
    private static final String HOSTNAME = "hostname";
    private static final String DOMAIN_NAME = "domainName";
    private final List<BiConsumer<ModelField, JsonObjectBuilder>> biConsumers = List.of((modelField, builder) -> {
        Pattern pattern = (Pattern)modelField.getAnnotation(Pattern.class);
        if (pattern != null && !pattern.off()) {
            builder.put(PATTERN, (Object)pattern.regexp());
        }
    }, (modelField, builder) -> {
        Length length = (Length)modelField.getAnnotation(Length.class);
        if (length != null && !length.off()) {
            builder.put(MIN_LENGTH, (Object)length.value());
            builder.put(MAX_LENGTH, (Object)length.value());
        }
    }, (modelField, builder) -> {
        MinLength minLength = (MinLength)modelField.getAnnotation(MinLength.class);
        if (minLength != null && !minLength.off()) {
            builder.put(MIN_LENGTH, (Object)minLength.value());
        }
    }, (modelField, builder) -> {
        MaxLength maxLength = (MaxLength)modelField.getAnnotation(MaxLength.class);
        if (maxLength != null && !maxLength.off()) {
            builder.put(MAX_LENGTH, (Object)maxLength.value());
        }
    }, (modelField, builder) -> {
        Enumeration enumeration = (Enumeration)modelField.getAnnotation(Enumeration.class);
        if (enumeration != null && !enumeration.off()) {
            builder.put(ENUM, List.of(enumeration.value()));
        }
    }, (modelField, builder) -> {
        Email email = (Email)modelField.getAnnotation(Email.class);
        if (email != null) {
            builder.put(FORMAT, (Object)EMAIL);
        }
    }, (modelField, builder) -> {
        IP ip = (IP)modelField.getAnnotation(IP.class);
        if (ip != null) {
            if (ip.value().length == 1) {
                builder.put(FORMAT, (Object)ip.value()[0].getJsonFormat());
            } else {
                builder.put(FORMAT, (Object)Arrays.stream(ip.value()).map(IP.Version::getJsonFormat).collect(Collectors.joining(", ")));
            }
        }
    }, (modelField, builder) -> {
        Phone phone = (Phone)modelField.getAnnotation(Phone.class);
        if (phone != null) {
            builder.put(FORMAT, (Object)PHONE);
        }
    }, (modelField, builder) -> {
        Telegram telegram = (Telegram)modelField.getAnnotation(Telegram.class);
        if (telegram != null) {
            builder.put(FORMAT, (Object)TELEGRAM);
        }
    }, (modelField, builder) -> {
        Viber viber = (Viber)modelField.getAnnotation(Viber.class);
        if (viber != null) {
            builder.put(FORMAT, (Object)VIBER);
        }
    }, (modelField, builder) -> {
        WhatsApp whatsApp = (WhatsApp)modelField.getAnnotation(WhatsApp.class);
        if (whatsApp != null) {
            builder.put(FORMAT, (Object)WHATSAPP);
        }
    }, (modelField, builder) -> {
        Skype skype = (Skype)modelField.getAnnotation(Skype.class);
        if (skype != null) {
            builder.put(FORMAT, (Object)SKYPE);
        }
    }, (modelField, builder) -> {
        URI uri = (URI)modelField.getAnnotation(URI.class);
        if (uri != null) {
            builder.put(FORMAT, (Object)URI);
        }
    }, (modelField, builder) -> {
        URLEncoded urlEncoded = (URLEncoded)modelField.getAnnotation(URLEncoded.class);
        if (urlEncoded != null) {
            builder.put(FORMAT, (Object)URL_ENCODED);
        }
    }, (modelField, builder) -> {
        HostName hostName = (HostName)modelField.getAnnotation(HostName.class);
        if (hostName != null) {
            builder.put(FORMAT, (Object)HOSTNAME);
        }
    }, (modelField, builder) -> {
        DomainName domainName = (DomainName)modelField.getAnnotation(DomainName.class);
        if (domainName != null) {
            builder.put(FORMAT, (Object)DOMAIN_NAME);
        }
    });

    public void read(JsonObjectBuilder builder, ModelField modelField) {
        this.biConsumers.forEach(biConsumer -> biConsumer.accept(modelField, builder));
    }
}

