/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.reader.attribute;

import io.rxmicro.annotation.processor.common.model.ModelField;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.json.JsonObjectBuilder;
import io.rxmicro.validation.constraint.Lat;
import io.rxmicro.validation.constraint.Lng;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinNumber;
import java.math.BigDecimal;
import java.util.List;
import java.util.function.BiConsumer;

public final class JsonNumberAttributesReader {
    private static final String MINIMUM = "minimum";
    private static final String EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String MAXIMUM = "maximum";
    private static final String EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final int MIN_LAT = -90;
    private static final int MAX_LAT = 90;
    private static final int MIN_LNG = -180;
    private static final int MAX_LNG = 180;
    private final List<BiConsumer<ModelField, JsonObjectBuilder>> biConsumers = List.of((modelField, builder) -> {
        Lat lat = (Lat)modelField.getAnnotation(Lat.class);
        if (lat != null && !lat.off()) {
            builder.put(MINIMUM, (Object)-90);
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
            builder.put(MAXIMUM, (Object)90);
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
    }, (modelField, builder) -> {
        Lng lng = (Lng)modelField.getAnnotation(Lng.class);
        if (lng != null && !lng.off()) {
            builder.put(MINIMUM, (Object)-180);
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
            builder.put(MAXIMUM, (Object)180);
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
    }, (modelField, builder) -> {
        MinDouble minDouble = (MinDouble)modelField.getAnnotation(MinDouble.class);
        if (minDouble != null && !minDouble.off()) {
            builder.put(MINIMUM, (Object)minDouble.value());
            builder.put(EXCLUSIVE_MINIMUM, (Object)false);
        }
    }, (modelField, builder) -> {
        MinInt minInt = (MinInt)modelField.getAnnotation(MinInt.class);
        if (minInt != null && !minInt.off()) {
            builder.put(MINIMUM, (Object)minInt.value());
            builder.put(EXCLUSIVE_MINIMUM, (Object)(!minInt.inclusive() ? 1 : 0));
        }
    }, (modelField, builder) -> {
        MinNumber minNumber = (MinNumber)modelField.getAnnotation(MinNumber.class);
        if (minNumber != null && !minNumber.off()) {
            builder.put(MINIMUM, (Object)new BigDecimal(Numbers.removeUnderscoresIfPresent((String)minNumber.value())));
            builder.put(EXCLUSIVE_MINIMUM, (Object)(!minNumber.inclusive() ? 1 : 0));
        }
    }, (modelField, builder) -> {
        MaxDouble maxDouble = (MaxDouble)modelField.getAnnotation(MaxDouble.class);
        if (maxDouble != null && !maxDouble.off()) {
            builder.put(MAXIMUM, (Object)maxDouble.value());
            builder.put(EXCLUSIVE_MAXIMUM, (Object)false);
        }
    }, (modelField, builder) -> {
        MaxInt maxInt = (MaxInt)modelField.getAnnotation(MaxInt.class);
        if (maxInt != null && !maxInt.off()) {
            builder.put(MAXIMUM, (Object)maxInt.value());
            builder.put(EXCLUSIVE_MAXIMUM, (Object)(!maxInt.inclusive() ? 1 : 0));
        }
    }, (modelField, builder) -> {
        MaxNumber maxNumber = (MaxNumber)modelField.getAnnotation(MaxNumber.class);
        if (maxNumber != null && !maxNumber.off()) {
            builder.put(MAXIMUM, (Object)new BigDecimal(Numbers.removeUnderscoresIfPresent((String)maxNumber.value())));
            builder.put(EXCLUSIVE_MAXIMUM, (Object)(!maxNumber.inclusive() ? 1 : 0));
        }
    });

    public void read(JsonObjectBuilder builder, ModelField modelField) {
        this.biConsumers.forEach(biConsumer -> biConsumer.accept(modelField, builder));
    }
}

