/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.converter;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Types;
import io.rxmicro.annotation.processor.documentation.component.impl.example.ExampleValueConverter;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.util.Formats;
import java.time.Instant;
import java.time.format.DateTimeParseException;

@Singleton
public final class DateTimeExampleValueConverter
extends ExampleValueConverter {
    @Override
    public boolean isSupported(RestModelField restModelField) {
        return Types.SUPPORTED_DATE_TIME_CLASSES.contains(restModelField.getFieldClass().toString());
    }

    @Override
    public Object convert(RestModelField restModelField, String value) {
        if (restModelField.getFieldClass().toString().equals(Instant.class.getName())) {
            try {
                Instant.parse(value);
                return value;
            }
            catch (DateTimeParseException ignore) {
                this.showInvalidExampleValueError(restModelField, Formats.format((String)"ISO-8601 instant (Example: '?')", (Object[])new Object[]{"1987-04-10T23:40:15.789Z"}), value);
                return ERROR_DETECTED;
            }
        }
        throw new UnsupportedOperationException("Not impl yet");
    }
}

