/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Errors;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.HttpResponseExampleBuilder;
import io.rxmicro.annotation.processor.documentation.component.JsonStructureExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.annotation.processor.rest.model.RestObjectModelClass;
import io.rxmicro.annotation.processor.rest.server.model.ModelWriterClassStructure;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerClassStructureStorage;
import io.rxmicro.annotation.processor.rest.server.model.RestControllerMethod;
import io.rxmicro.common.util.Formats;
import io.rxmicro.documentation.ResourceDefinition;
import io.rxmicro.files.PropertiesResources;
import io.rxmicro.json.JsonHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Singleton
public final class HttpResponseExampleBuilderImpl
implements HttpResponseExampleBuilder {
    private final Map<Integer, String> statusCodes;
    private final Map<Integer, String> statusCodeGroups = Map.of(1, "Information response", 2, "Successful response", 3, "Information response", 4, "Client error response", 5, "Server error response");
    @Inject
    private JsonStructureExampleBuilder jsonStructureExampleBuilder;
    @Inject
    private ExampleValueBuilder exampleValueBuilder;

    public HttpResponseExampleBuilderImpl() {
        this.statusCodes = PropertiesResources.loadProperties((String)"status-codes.properties").map(m -> m.entrySet().stream().collect(Collectors.toMap(e -> Integer.parseInt((String)e.getKey()), Map.Entry::getValue))).orElse(Map.of());
    }

    @Override
    public String build(ResourceDefinition resourceDefinition, RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerMethod method) {
        List<Map.Entry<String, Object>> customHeaders = method.getToHttpDataType().stream().flatMap(t -> restControllerClassStructureStorage.getModelWriterClassStructure(t.asType().toString()).stream().flatMap(cl -> cl.getModelClass().getHeaderEntries().stream()).map(e -> Map.entry(((RestModelField)e.getKey()).getModelName(), this.exampleValueBuilder.getExample((RestModelField)e.getKey())))).collect(Collectors.toList());
        Optional<String> body = this.getJsonBodyExample(restControllerClassStructureStorage, method);
        return this.buildExample(resourceDefinition, method.getSuccessStatusCode(), customHeaders, body.orElse(null));
    }

    @Override
    public String build(ResourceDefinition resourceDefinition, int statusCode, RestObjectModelClass restObjectModelClass) {
        return this.buildExample(resourceDefinition, statusCode, List.of(), this.jsonStructureExampleBuilder.build(restObjectModelClass));
    }

    @Override
    public String buildErrorExample(ResourceDefinition resourceDefinition, int statusCode, String message) {
        String body = JsonHelper.toJsonString(Map.of("message", message), (boolean)true);
        return this.buildExample(resourceDefinition, statusCode, List.of(), body);
    }

    @Override
    public String buildErrorExample(ResourceDefinition resourceDefinition, int statusCode) {
        return this.buildExample(resourceDefinition, statusCode, List.of(), null);
    }

    @Override
    public Optional<String> getJsonBodyExample(RestControllerClassStructureStorage restControllerClassStructureStorage, RestControllerMethod method) {
        return method.getToHttpDataType().map(typeElement -> this.jsonStructureExampleBuilder.build(((ModelWriterClassStructure)restControllerClassStructureStorage.getModelWriterClassStructure(typeElement.asType().toString()).orElseThrow(Errors.createInternalErrorSupplier((String)"ModelWriterClassStructure not found for type: ?", (Object[])new Object[]{typeElement.asType()}))).getModelClass()));
    }

    private String buildExample(ResourceDefinition resourceDefinition, int statusCode, List<Map.Entry<String, Object>> customHeaders, String body) {
        StringBuilder httpMessageBuilder = new StringBuilder();
        httpMessageBuilder.append(Formats.format((String)"? ? ??", (Object[])new Object[]{"HTTP/1.1", statusCode, this.getStatusMessage(statusCode), System.lineSeparator()}));
        if (body != null) {
            httpMessageBuilder.append("Content-Type: application/json").append(System.lineSeparator());
            httpMessageBuilder.append(Formats.format((String)"Content-Length: ?", (Object[])new Object[]{this.getContentLength(body)})).append(System.lineSeparator());
        } else {
            httpMessageBuilder.append("Content-Length: 0").append(System.lineSeparator());
        }
        if (resourceDefinition.withRequestIdResponseHeader()) {
            httpMessageBuilder.append(Formats.format((String)"Request-Id: ?", (Object[])new Object[]{"62jJeu8x1310662"})).append(System.lineSeparator());
        }
        customHeaders.forEach(e -> httpMessageBuilder.append(Formats.format((String)"?: ?", (Object[])new Object[]{e.getKey(), e.getValue()})).append(System.lineSeparator()));
        if (body != null) {
            httpMessageBuilder.append(System.lineSeparator());
            httpMessageBuilder.append(body);
        }
        return httpMessageBuilder.toString();
    }

    private int getContentLength(String body) {
        return body.replace("\r", "").length();
    }

    private String getStatusMessage(int statusCode) {
        return Optional.ofNullable(this.statusCodes.get(statusCode)).orElseGet(() -> {
            int httpStatusGroupStep = 100;
            int group = statusCode % 100;
            return Optional.ofNullable(this.statusCodeGroups.get(group)).orElse("");
        });
    }
}

