/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.definition.SupportedTypesProvider;
import io.rxmicro.annotation.processor.documentation.component.ExampleValueBuilder;
import io.rxmicro.annotation.processor.documentation.component.impl.example.ExampleValueConverter;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.documentation.Example;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class ExampleValueBuilderImpl
implements ExampleValueBuilder {
    private final Map<RestModelField, List<Object>> cache = new HashMap<RestModelField, List<Object>>();
    @Inject
    private Set<TypeExampleBuilder> exampleBuilders;
    @Inject
    private Set<ExampleValueConverter> exampleValueConverters;
    @Inject
    private SupportedTypesProvider supportedTypesProvider;

    @Override
    public List<Object> getExamples(RestModelField restModelField) {
        return this.cache.computeIfAbsent(restModelField, m -> this.extractExampleFromField(restModelField));
    }

    private List<Object> extractExampleFromField(RestModelField restModelField) {
        Example[] examples = (Example[])restModelField.getAnnotationsByType(Example.class);
        if (examples.length > 0) {
            return Arrays.stream(examples).map(example -> this.exampleValueConverters.stream().filter(b -> b.isSupported(restModelField)).map(b -> b.convert(restModelField, example.value())).findFirst().orElse(example.value())).collect(Collectors.toUnmodifiableList());
        }
        TypeMirror fieldClass = this.supportedTypesProvider.isModelPrimitiveList(restModelField.getFieldClass()) ? ((DeclaredType)restModelField.getFieldClass()).getTypeArguments().get(0) : restModelField.getFieldClass();
        return Collections.singletonList(this.exampleBuilders.stream().filter(b -> b.isSupported(restModelField, fieldClass)).map(b -> b.getExample(restModelField, fieldClass)).findFirst().orElse(null));
    }
}

