/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.model;

import io.rxmicro.annotation.processor.documentation.model.AuthorMetaData;
import io.rxmicro.annotation.processor.documentation.model.LicenseMetaData;
import io.rxmicro.common.util.Requires;
import java.time.LocalDate;
import java.util.List;

public final class ProjectMetaData {
    private final String projectDirectory;
    private final String name;
    private final String description;
    private final String version;
    private final String baseEndpoint;
    private final LocalDate currentDate;
    private final List<AuthorMetaData> authors;
    private final List<LicenseMetaData> licenses;

    private ProjectMetaData(String projectDirectory, String name, String description, String version, String baseEndpoint, List<AuthorMetaData> authors, List<LicenseMetaData> licenses) {
        this.projectDirectory = (String)Requires.require((Object)projectDirectory);
        this.name = (String)Requires.require((Object)name);
        this.description = description;
        this.version = version;
        this.baseEndpoint = baseEndpoint;
        this.authors = (List)Requires.require(authors);
        this.licenses = (List)Requires.require(licenses);
        this.currentDate = LocalDate.now();
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDescriptionPresent() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isVersionPresent() {
        return this.version != null;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCurrentDate() {
        return this.currentDate.toString();
    }

    public boolean isBaseEndpointPresent() {
        return this.baseEndpoint != null;
    }

    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }

    public List<AuthorMetaData> getAuthors() {
        return this.authors;
    }

    public List<LicenseMetaData> getLicenses() {
        return this.licenses;
    }

    public boolean isFewLicenses() {
        return this.licenses.size() > 1;
    }

    public static final class Builder {
        private String projectDirectory;
        private String name;
        private String description;
        private String version;
        private String baseEndpoint;
        private List<AuthorMetaData> authors;
        private List<LicenseMetaData> licenses;

        public Builder setProjectDirectory(String projectDirectory) {
            this.projectDirectory = (String)Requires.require((Object)projectDirectory);
            return this;
        }

        public Builder setName(String name) {
            this.name = (String)Requires.require((Object)name);
            return this;
        }

        public Builder setDescription(String description) {
            this.description = (String)Requires.require((Object)description);
            return this;
        }

        public Builder setVersion(String version) {
            this.version = (String)Requires.require((Object)version);
            return this;
        }

        public Builder setBaseEndpoint(String baseEndpoint) {
            this.baseEndpoint = (String)Requires.require((Object)baseEndpoint);
            return this;
        }

        public Builder setAuthors(List<AuthorMetaData> authors) {
            this.authors = (List)Requires.require(authors);
            return this;
        }

        public Builder setLicenses(List<LicenseMetaData> licenses) {
            this.licenses = (List)Requires.require(licenses);
            return this;
        }

        public ProjectMetaData build() {
            return new ProjectMetaData(this.projectDirectory, this.name, this.description, this.version, this.baseEndpoint, this.authors, this.licenses);
        }
    }
}

