/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.model;

import io.rxmicro.annotation.processor.documentation.model.AuthorMetaData;
import io.rxmicro.annotation.processor.documentation.model.LicenseMetaData;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaDataProvider;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Model;

public final class MavenPOMProjectMetaDataProvider
implements ProjectMetaDataProvider {
    private final String projectDirectory;
    private final List<Model> models;

    public MavenPOMProjectMetaDataProvider(String projectDirectory, List<Model> models) {
        this.projectDirectory = projectDirectory;
        this.models = List.copyOf(models);
    }

    @Override
    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    @Override
    public Optional<String> getTitle() {
        return this.models.stream().flatMap(model -> Optional.ofNullable(model.getName()).stream()).findFirst();
    }

    @Override
    public Optional<String> getDescription() {
        return this.models.stream().flatMap(model -> Optional.ofNullable(model.getDescription()).stream()).findFirst();
    }

    @Override
    public Optional<String> getVersion() {
        return this.models.stream().flatMap(model -> Optional.ofNullable(model.getVersion()).stream()).findFirst();
    }

    @Override
    public Optional<String> getBaseEndpoint() {
        return this.models.stream().flatMap(model -> Optional.ofNullable(model.getUrl()).stream()).findFirst();
    }

    @Override
    public List<AuthorMetaData> getAuthors() {
        return this.models.stream().flatMap(m -> m.getDevelopers().stream()).filter(d -> d.getEmail() != null && d.getName() != null).map(d -> new AuthorMetaData(d.getName(), d.getEmail())).collect(Collectors.toList());
    }

    @Override
    public List<LicenseMetaData> getLicenses() {
        return this.models.stream().flatMap(m -> m.getLicenses().stream()).filter(d -> d.getUrl() != null && d.getName() != null).map(d -> new LicenseMetaData(d.getName(), d.getUrl())).collect(Collectors.toList());
    }
}

