/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.converter;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.documentation.component.impl.example.ExampleValueConverter;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.validation.constraint.AssertFalse;
import io.rxmicro.validation.constraint.AssertTrue;

@Singleton
public final class BooleanExampleValueConverter
extends ExampleValueConverter {
    @Override
    public boolean isSupported(RestModelField restModelField) {
        return Boolean.class.getName().equals(restModelField.getFieldClass().toString());
    }

    @Override
    public Object convert(RestModelField restModelField, String value) {
        if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            boolean result = Boolean.parseBoolean(value);
            if (restModelField.getAnnotation(AssertTrue.class) != null) {
                if (!result) {
                    this.showInvalidExampleValueError(restModelField, "true", "false");
                    return ERROR_DETECTED;
                }
                return result;
            }
            if (restModelField.getAnnotation(AssertFalse.class) != null) {
                if (result) {
                    this.showInvalidExampleValueError(restModelField, "false", "true");
                    return ERROR_DETECTED;
                }
                return result;
            }
            return result;
        }
        this.showInvalidExampleTypeError(restModelField, Boolean.class, value);
        return ERROR_DETECTED;
    }
}

