/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.ImpossibleException;
import io.rxmicro.rest.RequestId;
import io.rxmicro.validation.constraint.Base64URLEncoded;
import io.rxmicro.validation.constraint.CountryCode;
import io.rxmicro.validation.constraint.DigitsOnly;
import io.rxmicro.validation.constraint.DomainName;
import io.rxmicro.validation.constraint.Email;
import io.rxmicro.validation.constraint.HostName;
import io.rxmicro.validation.constraint.IP;
import io.rxmicro.validation.constraint.LatinAlphabetOnly;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.Phone;
import io.rxmicro.validation.constraint.Skype;
import io.rxmicro.validation.constraint.Telegram;
import io.rxmicro.validation.constraint.URI;
import io.rxmicro.validation.constraint.Uppercase;
import io.rxmicro.validation.constraint.Viber;
import io.rxmicro.validation.constraint.WhatsApp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class StringExampleBuilder
implements TypeExampleBuilder {
    private final List<StringValueExampleBuilder> stringValueExampleBuilders = List.of(restModelField -> Optional.ofNullable((Base64URLEncoded)restModelField.getAnnotation(Base64URLEncoded.class)).filter(a -> !a.off()).map(a -> "SGVsbG8gd29ybGQh"), restModelField -> Optional.ofNullable((CountryCode)restModelField.getAnnotation(CountryCode.class)).filter(a -> !a.off()).map(this::getCountryCodeExample), restModelField -> Optional.ofNullable((DigitsOnly)restModelField.getAnnotation(DigitsOnly.class)).filter(a -> !a.off()).map(a -> "9876"), restModelField -> Optional.ofNullable((Email)restModelField.getAnnotation(Email.class)).filter(a -> !a.off()).map(a -> "welcome@rxmicro.io"), restModelField -> Optional.ofNullable((HostName)restModelField.getAnnotation(HostName.class)).filter(a -> !a.off()).map(a -> "rxmicro.io"), restModelField -> Optional.ofNullable((DomainName)restModelField.getAnnotation(DomainName.class)).filter(a -> !a.off()).map(a -> "rxmicro.io"), restModelField -> Optional.ofNullable((IP)restModelField.getAnnotation(IP.class)).filter(a -> !a.off()).map(this::getIPExample), restModelField -> Optional.ofNullable((LatinAlphabetOnly)restModelField.getAnnotation(LatinAlphabetOnly.class)).filter(a -> !a.off()).map(a -> "Latin alphabet only!"), restModelField -> Optional.ofNullable((Phone)restModelField.getAnnotation(Phone.class)).filter(a -> !a.off()).map(a -> this.getPhoneExample(a.withoutPlus())), restModelField -> Optional.ofNullable((Skype)restModelField.getAnnotation(Skype.class)).filter(a -> !a.off()).map(a -> "rxmicro.io"), restModelField -> Optional.ofNullable((Telegram)restModelField.getAnnotation(Telegram.class)).filter(a -> !a.off()).map(a -> this.getTelegramExample(a.withoutPlus())), restModelField -> Optional.ofNullable((Uppercase)restModelField.getAnnotation(Uppercase.class)).filter(a -> !a.off()).map(a -> "UPPERCASE"), restModelField -> Optional.ofNullable((URI)restModelField.getAnnotation(URI.class)).filter(a -> !a.off()).map(a -> "https://rxmicro.io"), restModelField -> Optional.ofNullable((URI)restModelField.getAnnotation(URI.class)).filter(a -> !a.off()).map(a -> "Hello%20world%21"), restModelField -> Optional.ofNullable((Viber)restModelField.getAnnotation(Viber.class)).filter(a -> !a.off()).map(a -> this.getViberExample(a.withoutPlus())), restModelField -> Optional.ofNullable((WhatsApp)restModelField.getAnnotation(WhatsApp.class)).filter(a -> !a.off()).map(a -> this.getWhatsappExample(a.withoutPlus())), restModelField -> Optional.ofNullable((Pattern)restModelField.getAnnotation(Pattern.class)).filter(a -> !a.off()).map(Pattern::regexp));

    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        return String.class.getName().equals(typeMirror.toString());
    }

    @Override
    public String getExample(RestModelField restModelField, TypeMirror typeMirror) {
        if (restModelField.getAnnotation(RequestId.class) != null || restModelField.isHttpHeader() && "Request-Id".equalsIgnoreCase(restModelField.getModelName())) {
            return "62jJeu8x1310662";
        }
        return this.stringValueExampleBuilders.stream().flatMap(builder -> builder.build(restModelField).stream()).findFirst().orElse("string");
    }

    private String getPhoneExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12254359430";
        }
        return "+12254359430";
    }

    private String getWhatsappExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12257117934";
        }
        return "+12257117934";
    }

    private String getTelegramExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12256782613";
        }
        return "+12256782613";
    }

    private String getViberExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12257111123";
        }
        return "+12257111123";
    }

    private String getIPExample(IP ip) {
        HashSet<IP.Version> versions = new HashSet<IP.Version>(Arrays.asList(ip.value()));
        if (versions.contains(IP.Version.IP_V4)) {
            return "8.8.8.8";
        }
        return "2001:db8:85a3::8a2e:370:7334";
    }

    private String getCountryCodeExample(CountryCode countryCode) {
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_ALPHA_2) {
            return "US";
        }
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_ALPHA_3) {
            return "USA";
        }
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_NUMERIC) {
            return "840";
        }
        throw new ImpossibleException("Unsupported CountryCode format: ?", new Object[]{countryCode.format()});
    }

    private static interface StringValueExampleBuilder {
        public Optional<String> build(RestModelField var1);
    }
}

