/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.converter;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.component.NumberValidators;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.component.impl.example.ExampleValueConverter;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.documentation.Example;
import io.rxmicro.json.JsonNumber;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

@Singleton
public final class NumberExampleValueConverter
extends ExampleValueConverter {
    private final Map<String, RangeValidator> validatorTypeMap = Map.of(Byte.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateByte(arg_0, arg_1, arg_2), Short.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateShort(arg_0, arg_1, arg_2), Integer.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateInteger(arg_0, arg_1, arg_2), Long.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateLong(arg_0, arg_1, arg_2), Float.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateFloat(arg_0, arg_1, arg_2), Double.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateDouble(arg_0, arg_1, arg_2), BigInteger.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateBigInteger(arg_0, arg_1, arg_2), BigDecimal.class.getName(), (arg_0, arg_1, arg_2) -> ((NumberValidators)numberValidators).validateBigDecimal(arg_0, arg_1, arg_2));

    @Inject
    public NumberExampleValueConverter(NumberValidators numberValidators) {
    }

    @Override
    public boolean isSupported(RestModelField restModelField) {
        return this.validatorTypeMap.containsKey(restModelField.getFieldClass().toString());
    }

    @Override
    public Object convert(RestModelField restModelField, String value) {
        String number = Numbers.removeUnderscoresIfPresent((String)value);
        if (this.validatorTypeMap.get(restModelField.getFieldClass().toString()).validate(restModelField, value, Example.class)) {
            return new JsonNumber(number);
        }
        return ERROR_DETECTED;
    }

    private static interface RangeValidator {
        public boolean validate(RestModelField var1, String var2, Class<? extends Annotation> var3);
    }
}

