/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.converter;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Elements;
import io.rxmicro.annotation.processor.documentation.component.impl.example.ExampleValueConverter;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.common.util.Formats;
import io.rxmicro.validation.constraint.Enumeration;
import io.rxmicro.validation.constraint.SubEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class EnumExampleValueConverter
extends ExampleValueConverter {
    @Override
    public boolean isSupported(RestModelField restModelField) {
        Optional typeElementOptional = Elements.asEnumElement((TypeMirror)restModelField.getFieldClass());
        if (typeElementOptional.isPresent()) {
            return true;
        }
        Enumeration enumeration = (Enumeration)restModelField.getAnnotation(Enumeration.class);
        return enumeration != null && !enumeration.off();
    }

    @Override
    public Object convert(RestModelField restModelField, String value) {
        Optional typeElementOptional = Elements.asEnumElement((TypeMirror)restModelField.getFieldClass());
        if (typeElementOptional.isPresent()) {
            return this.convertEnum(restModelField, (TypeElement)typeElementOptional.get(), value);
        }
        Enumeration enumeration = (Enumeration)restModelField.getAnnotation(Enumeration.class);
        if (enumeration.value().length > 0) {
            if (!Set.of(enumeration.value()).contains(value)) {
                this.showInvalidExampleValueError(restModelField, Formats.format((String)"one from the set: ?", (Object[])new Object[]{Arrays.toString(enumeration.value())}), value);
                return ERROR_DETECTED;
            }
            return value;
        }
        throw new InterruptProcessingException(restModelField.getElementAnnotatedBy(Enumeration.class), "Missing enumeration values! Add at least one item!", new Object[0]);
    }

    private Object convertEnum(RestModelField restModelField, TypeElement typeElement, String value) {
        Set<String> verifySet;
        Set<String> enumConstants = Elements.getAllowedEnumConstants((TypeMirror)typeElement.asType());
        if (enumConstants.isEmpty()) {
            throw new InterruptProcessingException(restModelField.getFieldElement(), "Missing enum constants! Add at least one constant to '?' class!", new Object[]{typeElement.getQualifiedName()});
        }
        SubEnum subEnum = (SubEnum)restModelField.getAnnotation(SubEnum.class);
        if (subEnum != null && !subEnum.off()) {
            if (subEnum.include().length > 0) {
                verifySet = Set.of(subEnum.include());
            } else {
                HashSet<String> excludes = new HashSet<String>(Arrays.asList(subEnum.exclude()));
                verifySet = enumConstants.stream().filter(c -> !excludes.contains(c)).collect(Collectors.toSet());
                if (verifySet.isEmpty()) {
                    throw new InterruptProcessingException(restModelField.getElementAnnotatedBy(SubEnum.class), "All enum constants are excluded!", new Object[0]);
                }
            }
        } else {
            verifySet = enumConstants;
        }
        if (!verifySet.contains(value)) {
            this.showInvalidExampleValueError(restModelField, Formats.format((String)"one from the set: ?", (Object[])new Object[]{verifySet}), value);
            return ERROR_DETECTED;
        }
        return value;
    }
}

