/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.rest.RequestId;
import io.rxmicro.validation.constraint.Base64URLEncoded;
import io.rxmicro.validation.constraint.CountryCode;
import io.rxmicro.validation.constraint.DigitsOnly;
import io.rxmicro.validation.constraint.DomainName;
import io.rxmicro.validation.constraint.Email;
import io.rxmicro.validation.constraint.HostName;
import io.rxmicro.validation.constraint.IP;
import io.rxmicro.validation.constraint.LatinAlphabetOnly;
import io.rxmicro.validation.constraint.Pattern;
import io.rxmicro.validation.constraint.Phone;
import io.rxmicro.validation.constraint.Skype;
import io.rxmicro.validation.constraint.Telegram;
import io.rxmicro.validation.constraint.URI;
import io.rxmicro.validation.constraint.URLEncoded;
import io.rxmicro.validation.constraint.Uppercase;
import io.rxmicro.validation.constraint.Viber;
import io.rxmicro.validation.constraint.WhatsApp;
import java.util.Arrays;
import java.util.HashSet;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class StringExampleBuilder
implements TypeExampleBuilder {
    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        return String.class.getName().equals(typeMirror.toString());
    }

    @Override
    public String getExample(RestModelField restModelField, TypeMirror typeMirror) {
        Base64URLEncoded base64URLEncoded = (Base64URLEncoded)restModelField.getAnnotation(Base64URLEncoded.class);
        if (base64URLEncoded != null && !base64URLEncoded.off()) {
            return "SGVsbG8gd29ybGQh";
        }
        CountryCode countryCode = (CountryCode)restModelField.getAnnotation(CountryCode.class);
        if (countryCode != null && !countryCode.off()) {
            return this.getCountryCodeExample(countryCode);
        }
        DigitsOnly digitsOnly = (DigitsOnly)restModelField.getAnnotation(DigitsOnly.class);
        if (digitsOnly != null && !digitsOnly.off()) {
            return "9876";
        }
        Email email = (Email)restModelField.getAnnotation(Email.class);
        if (email != null && !email.off()) {
            return "welcome@rxmicro.io";
        }
        HostName hostName = (HostName)restModelField.getAnnotation(HostName.class);
        if (hostName != null && !hostName.off()) {
            return "rxmicro.io";
        }
        DomainName domainName = (DomainName)restModelField.getAnnotation(DomainName.class);
        if (domainName != null && !domainName.off()) {
            return "rxmicro.io";
        }
        IP ip = (IP)restModelField.getAnnotation(IP.class);
        if (ip != null && !ip.off()) {
            return this.getIPExample(ip);
        }
        LatinAlphabetOnly latinAlphabetOnly = (LatinAlphabetOnly)restModelField.getAnnotation(LatinAlphabetOnly.class);
        if (latinAlphabetOnly != null && !latinAlphabetOnly.off()) {
            return "Latin alphabet only!";
        }
        Phone phone = (Phone)restModelField.getAnnotation(Phone.class);
        if (phone != null && !phone.off()) {
            return this.getPhoneExample(phone.withoutPlus());
        }
        Skype skype = (Skype)restModelField.getAnnotation(Skype.class);
        if (skype != null && !skype.off()) {
            return "rxmicro.io";
        }
        Telegram telegram = (Telegram)restModelField.getAnnotation(Telegram.class);
        if (telegram != null && !telegram.off()) {
            return this.getTelegramExample(telegram.withoutPlus());
        }
        Uppercase uppercase = (Uppercase)restModelField.getAnnotation(Uppercase.class);
        if (uppercase != null && !uppercase.off()) {
            return "STRING";
        }
        URI uri = (URI)restModelField.getAnnotation(URI.class);
        if (uri != null && !uri.off()) {
            return "https://rxmicro.io";
        }
        URLEncoded urlEncoded = (URLEncoded)restModelField.getAnnotation(URLEncoded.class);
        if (urlEncoded != null && !urlEncoded.off()) {
            return "Hello%20world%21";
        }
        Viber viber = (Viber)restModelField.getAnnotation(Viber.class);
        if (viber != null && !viber.off()) {
            return this.getViberExample(viber.withoutPlus());
        }
        WhatsApp whatsApp = (WhatsApp)restModelField.getAnnotation(WhatsApp.class);
        if (whatsApp != null && !whatsApp.off()) {
            return this.getWhatsappExample(whatsApp.withoutPlus());
        }
        Pattern pattern = (Pattern)restModelField.getAnnotation(Pattern.class);
        if (pattern != null && !pattern.off()) {
            return pattern.regexp();
        }
        if (restModelField.getAnnotation(RequestId.class) != null) {
            return "62jJeu8x1310662";
        }
        if (restModelField.isHttpHeader() && "Request-Id".equalsIgnoreCase(restModelField.getModelName())) {
            return "62jJeu8x1310662";
        }
        return "string";
    }

    private String getPhoneExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12254359430";
        }
        return "+12254359430";
    }

    private String getWhatsappExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12257117934";
        }
        return "+12257117934";
    }

    private String getTelegramExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12256782613";
        }
        return "+12256782613";
    }

    private String getViberExample(boolean withoutPlus) {
        if (withoutPlus) {
            return "12257111123";
        }
        return "+12257111123";
    }

    private String getIPExample(IP ip) {
        HashSet<IP.Version> versions = new HashSet<IP.Version>(Arrays.asList(ip.value()));
        if (versions.contains(IP.Version.IP_V4)) {
            return "8.8.8.8";
        }
        return "2001:db8:85a3::8a2e:370:7334";
    }

    private String getCountryCodeExample(CountryCode countryCode) {
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_ALPHA_2) {
            return "US";
        }
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_ALPHA_3) {
            return "USA";
        }
        if (countryCode.format() == CountryCode.Format.ISO_3166_1_NUMERIC) {
            return "840";
        }
        throw new UnsupportedOperationException("Unsupported CountryCode format: " + countryCode.format());
    }
}

