/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl.example.builder;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.Numbers;
import io.rxmicro.annotation.processor.documentation.component.impl.example.TypeExampleBuilder;
import io.rxmicro.annotation.processor.rest.model.RestModelField;
import io.rxmicro.json.JsonNumber;
import io.rxmicro.validation.base.LocationAccuracy;
import io.rxmicro.validation.constraint.Lat;
import io.rxmicro.validation.constraint.Lng;
import io.rxmicro.validation.constraint.MaxDouble;
import io.rxmicro.validation.constraint.MaxInt;
import io.rxmicro.validation.constraint.MaxNumber;
import io.rxmicro.validation.constraint.MinDouble;
import io.rxmicro.validation.constraint.MinInt;
import io.rxmicro.validation.constraint.MinNumber;
import io.rxmicro.validation.constraint.Numeric;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Set;
import javax.lang.model.type.TypeMirror;

@Singleton
public final class NumberExampleBuilder
implements TypeExampleBuilder {
    private static final Set<String> NUMBERS = Set.of(Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName());

    @Override
    public boolean isSupported(RestModelField restModelField, TypeMirror typeMirror) {
        return NUMBERS.contains(typeMirror.toString());
    }

    public JsonNumber getExample(RestModelField restModelField, TypeMirror typeMirror) {
        Lat lat = (Lat)restModelField.getAnnotation(Lat.class);
        if (lat != null && !lat.off()) {
            return this.withLocationAccuracy("34.063821", lat.value());
        }
        Lng lng = (Lng)restModelField.getAnnotation(Lng.class);
        if (lng != null && !lng.off()) {
            return this.withLocationAccuracy("-118.296339", lng.value());
        }
        MaxDouble maxDouble = (MaxDouble)restModelField.getAnnotation(MaxDouble.class);
        if (maxDouble != null && !maxDouble.off()) {
            return new JsonNumber(String.valueOf(maxDouble.value()));
        }
        MaxInt maxInt = (MaxInt)restModelField.getAnnotation(MaxInt.class);
        if (maxInt != null && !maxInt.off()) {
            return new JsonNumber(String.valueOf(maxInt.value()));
        }
        MaxNumber maxNumber = (MaxNumber)restModelField.getAnnotation(MaxNumber.class);
        if (maxNumber != null && !maxNumber.off()) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)maxNumber.value()));
        }
        MinDouble minDouble = (MinDouble)restModelField.getAnnotation(MinDouble.class);
        if (minDouble != null && !minDouble.off()) {
            return new JsonNumber(String.valueOf(minDouble.value()));
        }
        MinInt minInt = (MinInt)restModelField.getAnnotation(MinInt.class);
        if (minInt != null && !minInt.off()) {
            return new JsonNumber(String.valueOf(minInt.value()));
        }
        MinNumber minNumber = (MinNumber)restModelField.getAnnotation(MinNumber.class);
        if (minNumber != null && !minNumber.off()) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)minNumber.value()));
        }
        Numeric numeric = (Numeric)restModelField.getAnnotation(Numeric.class);
        if (numeric != null && !numeric.off()) {
            BigDecimal bigDecimal = new BigDecimal("987654321.987654321");
            if (numeric.scale() > -1) {
                return new JsonNumber(bigDecimal.setScale(numeric.scale(), RoundingMode.HALF_UP).toPlainString());
            }
            return new JsonNumber(bigDecimal.toPlainString());
        }
        if (Byte.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber("10");
        }
        if (Short.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"10_000"));
        }
        if (Integer.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000"));
        }
        if (Long.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000_000"));
        }
        if (BigInteger.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber(Numbers.removeUnderscoresIfPresent((String)"1_000_000_000_000_000_000_000"));
        }
        if (Float.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber("3.14");
        }
        if (Double.class.getName().equals(typeMirror.toString())) {
            return new JsonNumber("3.1415926535");
        }
        return new JsonNumber("3.1415926535897932384626433832795028841971");
    }

    private JsonNumber withLocationAccuracy(String value, LocationAccuracy locationAccuracy) {
        return new JsonNumber(new BigDecimal(value).setScale(locationAccuracy.getCoordinateScale(), RoundingMode.HALF_UP).toPlainString());
    }
}

