/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.documentation.component.TitleReader;
import io.rxmicro.common.util.Strings;
import io.rxmicro.documentation.Title;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;

@Singleton
public final class TitleReaderImpl
implements TitleReader {
    @Override
    public Optional<String> getTitle(Element element) {
        return Optional.ofNullable(element.getAnnotation(Title.class)).map(Title::value);
    }

    @Override
    public String getDefaultTitle(Element element) {
        if (element instanceof ModuleElement) {
            return this.getHumanReadableModuleName(((ModuleElement)element).getQualifiedName().toString());
        }
        if (element instanceof ExecutableElement) {
            return this.getHumanReadableClassOrMethod(element.getSimpleName().toString());
        }
        if (element instanceof TypeElement) {
            return this.getHumanReadableClassOrMethod(element.getSimpleName().toString());
        }
        return element.asType().toString();
    }

    private String getHumanReadableClassOrMethod(String moduleName) {
        List words = Strings.splitByCamelCase((String)moduleName);
        return words.stream().map(Strings::capitalize).collect(Collectors.joining(" "));
    }

    private String getHumanReadableModuleName(String moduleName) {
        return Arrays.stream(moduleName.split("\\.")).map(Strings::capitalize).collect(Collectors.joining(" "));
    }
}

