/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.documentation.component.DescriptionReader;
import io.rxmicro.annotation.processor.documentation.component.ProjectMetaDataProviderResolver;
import io.rxmicro.annotation.processor.documentation.component.ProjectMetaDataReader;
import io.rxmicro.annotation.processor.documentation.component.TitleReader;
import io.rxmicro.annotation.processor.documentation.model.AuthorMetaData;
import io.rxmicro.annotation.processor.documentation.model.LicenseMetaData;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaData;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaDataProvider;
import io.rxmicro.documentation.Author;
import io.rxmicro.documentation.BaseEndpoint;
import io.rxmicro.documentation.DocumentationVersion;
import io.rxmicro.documentation.License;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.ModuleElement;

@Singleton
public final class ProjectMetaDataReaderImpl
implements ProjectMetaDataReader {
    @Inject
    private TitleReader titleReader;
    @Inject
    private DescriptionReader descriptionReader;
    @Inject
    private ProjectMetaDataProviderResolver projectMetaDataProviderResolver;

    @Override
    public ProjectMetaData read(ModuleElement currentModule) {
        ProjectMetaDataProvider projectMetaDataProvider = this.projectMetaDataProviderResolver.resolve();
        ProjectMetaData.Builder builder = new ProjectMetaData.Builder().setProjectDirectory(projectMetaDataProvider.getProjectDirectory()).setName(this.titleReader.getTitle(currentModule).orElseGet(() -> projectMetaDataProvider.getTitle().orElseGet(() -> this.titleReader.getDefaultTitle(currentModule))));
        this.descriptionReader.readDescription(currentModule, projectMetaDataProvider.getProjectDirectory()).or(projectMetaDataProvider::getDescription).ifPresent(builder::setDescription);
        Optional.ofNullable(currentModule.getAnnotation(DocumentationVersion.class)).map(DocumentationVersion::value).or(projectMetaDataProvider::getVersion).ifPresent(builder::setVersion);
        Optional.ofNullable(currentModule.getAnnotation(BaseEndpoint.class)).map(BaseEndpoint::value).or(projectMetaDataProvider::getBaseEndpoint).ifPresent(builder::setBaseEndpoint);
        return builder.setAuthors(this.getAuthors(currentModule, projectMetaDataProvider)).setLicenses(this.getLicenses(currentModule, projectMetaDataProvider)).build();
    }

    private List<AuthorMetaData> getAuthors(ModuleElement currentModule, ProjectMetaDataProvider projectMetaDataProvider) {
        Author[] annotationAuthors = (Author[])currentModule.getAnnotationsByType(Author.class);
        if (annotationAuthors.length > 0) {
            return Arrays.stream(annotationAuthors).map(a -> new AuthorMetaData(a.name(), a.email())).collect(Collectors.toList());
        }
        List<AuthorMetaData> providerAuthors = projectMetaDataProvider.getAuthors();
        if (!providerAuthors.isEmpty()) {
            return providerAuthors;
        }
        return List.of(new AuthorMetaData("GeneratedBy RxMicroAnnotationProcessor", "rxmicro.io@gmail.com"));
    }

    private List<LicenseMetaData> getLicenses(ModuleElement currentModule, ProjectMetaDataProvider projectMetaDataProvider) {
        License[] annotationLicenses = (License[])currentModule.getAnnotationsByType(License.class);
        if (annotationLicenses.length > 0) {
            return Arrays.stream(annotationLicenses).map(a -> new LicenseMetaData(a.name(), a.url())).collect(Collectors.toList());
        }
        List<LicenseMetaData> providerLicenses = projectMetaDataProvider.getLicenses();
        if (!providerLicenses.isEmpty()) {
            return providerLicenses;
        }
        return List.of(new LicenseMetaData("Apache License Version 2.0", "http://www.apache.org/licenses/LICENSE-2.0"));
    }
}

