/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.documentation.component.impl;

import com.google.inject.Singleton;
import io.rxmicro.annotation.processor.common.util.InternalLoggers;
import io.rxmicro.annotation.processor.common.util.ProcessingEnvironmentHelper;
import io.rxmicro.annotation.processor.common.util.Stubs;
import io.rxmicro.annotation.processor.documentation.component.ProjectMetaDataProviderResolver;
import io.rxmicro.annotation.processor.documentation.component.impl.model.MavenPOMProjectMetaDataProvider;
import io.rxmicro.annotation.processor.documentation.model.ProjectMetaDataProvider;
import io.rxmicro.common.CheckedWrapperException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Singleton
public final class ProjectMetaDataProviderResolverImpl
implements ProjectMetaDataProviderResolver {
    @Override
    public ProjectMetaDataProvider resolve() {
        return Optional.ofNullable(System.getProperty("RX_MICRO_POM_XML_ABSOLUTE_PATH")).map(File::new).filter(File::exists).or(this::getPomXmlAbsolutePath).flatMap(this::readMetaDataFromPomXML).orElseGet(() -> (ProjectMetaDataProvider)Stubs.stub(ProjectMetaDataProvider.class, (MethodHandles.Lookup)MethodHandles.lookup()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<File> getPomXmlAbsolutePath() {
        try {
            FileObject tempResource = ProcessingEnvironmentHelper.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", "test.properties", new Element[0]);
            try {
                File directory;
                URI uri = tempResource.toUri();
                try {
                    directory = new File(uri).getParentFile();
                }
                catch (IllegalArgumentException e) {
                    Optional<File> optional = Optional.empty();
                    tempResource.delete();
                    return optional;
                }
                while (directory != null) {
                    File pomXml = new File(directory, "pom.xml");
                    if (pomXml.exists()) {
                        Optional<File> optional = Optional.of(pomXml);
                        return optional;
                    }
                    directory = directory.getParentFile();
                }
                return Optional.empty();
            }
            finally {
                tempResource.delete();
            }
        }
        catch (IOException e) {
            InternalLoggers.logThrowableStackTrace((Throwable)new CheckedWrapperException((Throwable)e, "Can't detect `pom.xml` location!", new Object[0]));
        }
        return Optional.empty();
    }

    private Optional<ProjectMetaDataProvider> readMetaDataFromPomXML(File pomXmlPath) {
        try {
            Model model;
            Parent parent;
            MavenXpp3Reader reader = new MavenXpp3Reader();
            ArrayList<Model> models = new ArrayList<Model>();
            File pomXml = pomXmlPath;
            do {
                try (BufferedReader fileReader = Files.newBufferedReader(pomXml.toPath(), StandardCharsets.UTF_8);){
                    model = reader.read((Reader)fileReader);
                }
                model.setPomFile(pomXmlPath);
                models.add(model);
            } while ((parent = model.getParent()) != null && (pomXml = new File(pomXml.getParentFile(), parent.getRelativePath()).getAbsoluteFile()).exists());
            return Optional.of(new MavenPOMProjectMetaDataProvider(pomXmlPath.getParentFile().getAbsolutePath(), models));
        }
        catch (IOException | XmlPullParserException e) {
            InternalLoggers.logThrowableStackTrace((Throwable)new CheckedWrapperException(e, "Can't read data from `pom.xml`!", new Object[0]));
            return Optional.empty();
        }
    }
}

